/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.context;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;

public class PartFile {
    private String formName;
    private String fileName;
    private String filePath;
    private String contentType;
    private long length;
    private File file;

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public long getLength() {
        return this.length;
    }

    public void setLength(long length) {
        this.length = length;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public String extName() {
        return this.fileName.substring(this.fileName.lastIndexOf(".") + 1);
    }

    public String pointExtName() {
        return this.fileName.substring(this.fileName.lastIndexOf("."));
    }

    public void moveTo(File newFile) throws IOException {
        this.moveTo(Paths.get(newFile.getPath(), new String[0]));
    }

    private void moveTo(Path newFile) throws IOException {
        Files.move(Paths.get(this.file.getPath(), new String[0]), newFile, StandardCopyOption.REPLACE_EXISTING);
    }

    public byte[] getData() {
        byte[] fileContent;
        try {
            fileContent = Files.readAllBytes(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.file.delete();
        }
        return fileContent;
    }

    public FileInputStream getFileInputStream() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.file);
            return fileInputStream;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.file.delete();
        }
    }

    public String getFileToString() {
        try {
            String string = new String(Files.readAllBytes(this.file.toPath()), "UTF-8");
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            this.file.delete();
        }
    }

    public void deleteTempCacheFile() {
        this.file.delete();
    }

    public String toString() {
        long kb = this.length / 1024L;
        return "FileItem(name='" + this.formName + '\'' + "fileName='" + this.fileName + '\'' + ", path='" + this.filePath + '\'' + ", contentType='" + this.contentType + '\'' + ", size=" + (kb < 1L ? 1L : kb) + "KB)";
    }
}

