/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.context;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.util.CharsetUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import top.hserver.core.interfaces.HttpRequest;
import top.hserver.core.server.context.HeadMap;
import top.hserver.core.server.context.PartFile;
import top.hserver.core.server.handlers.HServerContentHandler;
import top.hserver.core.server.util.IpUtil;

public class Request
implements HttpRequest {
    private String requestId;
    private String uri;
    private String nettyUri;
    private HttpMethod requestType;
    private String ip;
    private int port;
    private String streamId;
    private ChannelHandlerContext ctx;
    private Map<String, List<String>> requestParams = new ConcurrentHashMap<String, List<String>>();
    private Map<String, List<String>> urlParams = new ConcurrentHashMap<String, List<String>>();
    private HeadMap headers;
    private FullHttpRequest nettyRequest;
    private final long createTime = System.currentTimeMillis();
    private HServerContentHandler handler;
    private static final ByteBuf EMPTY_BUF = Unpooled.copiedBuffer((CharSequence)"", (Charset)CharsetUtil.UTF_8);
    private byte[] body = null;
    private Map<String, PartFile> multipartFile = new HashMap<String, PartFile>(8);
    private static final String TEMP_PATH = System.getProperty("java.io.tmpdir") + File.separator;

    @Override
    public String getRequestId() {
        return this.requestId;
    }

    @Override
    public String getIpAddress() {
        return IpUtil.getIpAddr(this);
    }

    @Override
    public long getCreateTime() {
        return this.createTime;
    }

    @Override
    public String query(String name) {
        return this.requestParams.get(name) == null ? null : this.requestParams.get(name).get(0);
    }

    @Override
    public String queryUrl(String name) {
        return this.urlParams.get(name) == null ? null : this.urlParams.get(name).get(0);
    }

    @Override
    public PartFile queryFile(String name) {
        return this.multipartFile.get(name);
    }

    @Override
    public String getIp() {
        return this.ip;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    @Override
    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    @Override
    public String getNettyUri() {
        return this.nettyUri;
    }

    @Override
    public FullHttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    @Override
    public String getHeader(String headName) {
        return this.headers.get(headName);
    }

    @Override
    public String getRawData() {
        try {
            return new String(this.body, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void writeHttpData(InterfaceHttpData data) {
        try {
            InterfaceHttpData.HttpDataType dataType = data.getHttpDataType();
            if (dataType == InterfaceHttpData.HttpDataType.Attribute) {
                this.parseAttribute((Attribute)data);
            } else if (dataType == InterfaceHttpData.HttpDataType.FileUpload) {
                this.parseFileUpload((FileUpload)data);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void parseAttribute(Attribute attribute) throws IOException {
        this.addReqParams(attribute.getName(), attribute.getValue());
    }

    public void addReqParams(String key, String value) {
        if (this.requestParams.containsKey(key)) {
            this.requestParams.get(key).add(value);
        } else {
            ArrayList<String> data = new ArrayList<String>();
            data.add(value);
            this.requestParams.put(key, data);
        }
    }

    public void addReqUrlParams(String key, String value) {
        if (this.urlParams.containsKey(key)) {
            this.urlParams.get(key).add(value);
        } else {
            this.urlParams.put(key, Collections.singletonList(value));
        }
    }

    private void parseFileUpload(FileUpload fileUpload) throws IOException {
        if (fileUpload.isCompleted()) {
            PartFile partFile = new PartFile();
            partFile.setFormName(fileUpload.getName());
            partFile.setFileName(fileUpload.getFilename());
            String s = TEMP_PATH + "h_server_" + UUID.randomUUID() + "_upload";
            if (s.contains("../")) {
                fileUpload.delete();
                return;
            }
            File file = new File(s);
            fileUpload.renameTo(file);
            partFile.setFile(file);
            partFile.setFilePath(file.getPath());
            partFile.setContentType(fileUpload.getContentType());
            partFile.setLength(fileUpload.length());
            this.multipartFile.put(partFile.getFormName(), partFile);
        }
    }

    @Override
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setNettyUri(String nettyUri) {
        this.nettyUri = nettyUri;
    }

    @Override
    public HttpMethod getRequestType() {
        return this.requestType;
    }

    public void setRequestType(HttpMethod requestType) {
        this.requestType = requestType;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public Map<String, List<String>> getRequestParams() {
        return this.requestParams;
    }

    public void setRequestParams(Map<String, List<String>> requestParams) {
        this.requestParams = requestParams;
    }

    @Override
    public Map<String, List<String>> getUrlParams() {
        return this.urlParams;
    }

    public void setUrlParams(Map<String, List<String>> urlParams) {
        this.urlParams = urlParams;
    }

    public HeadMap getHeaders() {
        return this.headers;
    }

    public void setHeaders(HeadMap headers) {
        this.headers = headers;
    }

    public void setNettyRequest(FullHttpRequest nettyRequest) {
        this.nettyRequest = nettyRequest;
    }

    public static ByteBuf getEmptyBuf() {
        return EMPTY_BUF;
    }

    @Override
    public Map<String, PartFile> getMultipartFile() {
        return this.multipartFile;
    }

    public void setMultipartFile(Map<String, PartFile> multipartFile) {
        this.multipartFile = multipartFile;
    }

    public static String getTempPath() {
        return TEMP_PATH;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void setHandler(HServerContentHandler handler) {
        this.handler = handler;
    }

    @Override
    public String getStreamId() {
        return this.streamId;
    }

    public void setStreamId(String streamId) {
        this.streamId = streamId;
    }

    @Override
    public Channel getOutboundChannel() {
        return this.handler.outboundChannel;
    }

    @Override
    public void setOutboundChannel(Channel channel) {
        this.handler.outboundChannel = channel;
    }
}

