/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.context;

import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.HttpResponse;
import top.hserver.core.interfaces.ProgressStatus;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.Cookie;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.FreemarkerUtil;

public class Response
implements HttpResponse {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private Map<String, String> headers = new ConcurrentHashMap<String, String>();
    private File file;
    private InputStream inputStream;
    private boolean isDownload = false;
    private String fileName;
    private String result = null;
    private HttpResponseStatus httpResponseStatus;
    private boolean isProxy = false;

    @Override
    public boolean hasData() {
        if (this.result != null) {
            return true;
        }
        return this.isDownload;
    }

    @Override
    public void setHeader(String key, String value) {
        this.headers.put(key, value);
    }

    @Override
    public void setDownloadFile(File file) {
        this.file = file;
        this.isDownload = true;
        this.fileName = file.getName();
    }

    @Override
    public void setDownloadBigFile(final File file, final ProgressStatus progressStatus, ChannelHandlerContext ctx) throws Exception {
        this.isProxy(true);
        try {
            final RandomAccessFile raf = new RandomAccessFile(file, "r");
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)fileLength);
            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"application/octet-stream");
            response.headers().add((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)String.format("attachment; filename=\"%s\"", file.getName()));
            ctx.write((Object)response);
            ChannelFuture sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
            sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

                public void operationComplete(ChannelProgressiveFuture future) throws Exception {
                    log.info("file {} transfer complete.", (Object)file.getName());
                    progressStatus.operationComplete(file.getAbsolutePath());
                    raf.close();
                }

                public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) throws Exception {
                    progressStatus.downloading(progress, total);
                }
            });
            ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        }
        catch (FileNotFoundException e) {
            throw new Exception(String.format("\u6587\u4ef6 %s \u627e\u4e0d\u5230", file.getPath()));
        }
        catch (IOException e) {
            throw new Exception(String.format("\u8bfb\u53d6 \u6587\u4ef6 %s \u53d1\u751f\u5f02\u5e38", file.getAbsolutePath()));
        }
    }

    @Override
    public void setDownloadFile(InputStream inputStream, String fileName) {
        this.inputStream = inputStream;
        this.isDownload = true;
        this.fileName = fileName;
    }

    @Override
    public void sendJsonString(String jsonStr) {
        this.result = jsonStr;
        this.headers.put("content-type", "application/json;charset=UTF-8");
    }

    @Override
    public void sendJson(Object object) {
        try {
            this.result = ConstConfig.JSONADAPTER.convertString(object);
            this.headers.put("content-type", "application/json;charset=UTF-8");
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }

    @Override
    public void sendHtml(String html) {
        this.result = html;
        this.headers.put("content-type", "text/html;charset=UTF-8");
    }

    @Override
    public void sendText(String text) {
        this.result = text;
        this.headers.put("content-type", "text/plain;charset=UTF-8");
    }

    public void sendNull() {
        this.result = "";
    }

    @Override
    public void sendStatusCode(HttpResponseStatus httpResponseStatus) {
        this.httpResponseStatus = httpResponseStatus;
    }

    @Override
    public void isProxy(boolean p) {
        this.isProxy = p;
    }

    @Override
    public void sendTemplate(String htmlPath, Map<String, Object> obj) {
        try {
            this.result = FreemarkerUtil.getTemplate(htmlPath, obj);
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        this.headers.put("content-type", "text/html;charset=UTF-8");
    }

    @Override
    public void sendTemplate(String htmlPath) {
        this.sendTemplate(htmlPath, new HashMap<String, Object>(0));
    }

    @Override
    public void addCookie(Cookie cookie) {
        Iterator iterator = cookie.keySet().iterator();
        StringBuilder cookieStr = new StringBuilder();
        while (iterator.hasNext()) {
            String k = (String)iterator.next();
            String v = (String)cookie.get(k);
            try {
                cookieStr.append(URLEncoder.encode(k, "UTF-8") + "=" + URLEncoder.encode(v, "UTF-8") + ";");
            }
            catch (UnsupportedEncodingException e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }
        if (cookie.getMaxAge() != null) {
            cookieStr.append("Max-Age=");
            cookieStr.append(cookie.getMaxAge());
            cookieStr.append(";");
        }
        if (cookie.getPath() != null) {
            cookieStr.append("path=");
            cookieStr.append(cookie.getPath());
            cookieStr.append(";");
        }
        this.headers.put("Set-Cookie", cookieStr.toString());
    }

    @Override
    public void redirect(String url) {
        this.result = "";
        this.headers.put("location", url);
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public boolean isDownload() {
        return this.isDownload;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public HttpResponseStatus getHttpResponseStatus() {
        return this.httpResponseStatus;
    }

    public boolean isProxy() {
        return this.isProxy;
    }
}

