/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.dispatcher;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapter;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.ssl.OptionalSslHandler;
import io.netty.handler.traffic.GlobalTrafficShapingHandler;
import java.util.concurrent.ScheduledExecutorService;
import top.hserver.core.interfaces.ProtocolDispatcherAdapter;
import top.hserver.core.ioc.annotation.Bean;
import top.hserver.core.ioc.annotation.Order;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.handlers.HServerContentHandler;
import top.hserver.core.server.handlers.Http2OrHttpHandler;
import top.hserver.core.server.handlers.RouterHandler;
import top.hserver.core.server.handlers.WebSocketServerHandler;

@Order(value=3)
@Bean
public class DispatchHttp
implements ProtocolDispatcherAdapter {
    @Override
    public boolean dispatcher(ChannelHandlerContext ctx, ChannelPipeline pipeline, byte[] headers) {
        if (this.isHttps(headers[0], headers[1], headers[2])) {
            if (ConstConfig.sslContext != null) {
                pipeline.addLast(new ChannelHandler[]{new OptionalSslHandler(ConstConfig.sslContext)});
                if (ConstConfig.openHttp2.booleanValue()) {
                    pipeline.addLast(new ChannelHandler[]{new Http2OrHttpHandler()});
                } else {
                    DispatchHttp.httpHandler(ctx);
                }
            }
            return true;
        }
        if (this.isHttp(headers[0], headers[1])) {
            DispatchHttp.httpHandler(ctx);
            return true;
        }
        return false;
    }

    public static void httpHandler(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        if (ConstConfig.WRITE_LIMIT != null && ConstConfig.READ_LIMIT != null) {
            pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new GlobalTrafficShapingHandler((ScheduledExecutorService)ctx.executor().parent(), ConstConfig.WRITE_LIMIT.longValue(), ConstConfig.READ_LIMIT.longValue())});
        }
        pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HttpObjectAggregator(ConstConfig.HTTP_CONTENT_SIZE.intValue())});
        if (WebSocketServerHandler.WEB_SOCKET_ROUTER.size() > 0) {
            pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new WebSocketServerHandler()});
        }
        pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HServerContentHandler(false)});
        pipeline.addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new RouterHandler()});
    }

    public static void http2Handler(ChannelHandlerContext ctx) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(true);
        InboundHttp2ToHttpAdapter listener = new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).propagateSettings(true).validateHttpHeaders(false).maxContentLength(ConstConfig.HTTP_CONTENT_SIZE.intValue()).build();
        ctx.pipeline().addLast(new ChannelHandler[]{new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)listener).connection((Http2Connection)connection).build()});
        if (ConstConfig.WRITE_LIMIT != null && ConstConfig.READ_LIMIT != null) {
            ctx.pipeline().addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new GlobalTrafficShapingHandler((ScheduledExecutorService)ctx.executor().parent(), ConstConfig.WRITE_LIMIT.longValue(), ConstConfig.READ_LIMIT.longValue())});
        }
        ctx.pipeline().addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new HServerContentHandler(true)});
        ctx.pipeline().addLast(ConstConfig.BUSINESS_EVENT, new ChannelHandler[]{new RouterHandler()});
    }

    private boolean isHttp(int magic1, int magic2) {
        return magic1 == 71 && magic2 == 69 || magic1 == 80 && magic2 == 79 || magic1 == 80 && magic2 == 85 || magic1 == 72 && magic2 == 69 || magic1 == 79 && magic2 == 80 || magic1 == 80 && magic2 == 65 || magic1 == 68 && magic2 == 69 || magic1 == 84 && magic2 == 82 || magic1 == 67 && magic2 == 79;
    }

    private boolean isHttps(int magic1, int magic2, int magic3) {
        return magic1 == 22 && magic2 == 3 && magic3 == 1;
    }
}

