/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.HttpConversionUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import top.hserver.core.interfaces.HttpRequest;
import top.hserver.core.server.context.HServerContext;
import top.hserver.core.server.context.HServerContextHolder;
import top.hserver.core.server.context.MimeType;
import top.hserver.core.server.context.Request;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.exception.BusinessBean;
import top.hserver.core.server.exception.BusinessException;
import top.hserver.core.server.util.ByteBufUtil;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.FreemarkerUtil;

public class BuildResponse {
    public static FullHttpResponse buildStaticShowType(HServerContext hServerContext) {
        InputStream inputStream = hServerContext.getStaticFile().getInputStream();
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.fileToByteBuf(inputStream))));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(hServerContext.getStaticFile().getFileHead() + ";charset=UTF-8"));
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return response;
    }

    public static FullHttpResponse buildControllerDownloadType(Response response1) {
        DefaultFullHttpResponse response;
        if (response1.getFile() == null) {
            InputStream inputStream = response1.getInputStream();
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.fileToByteBuf(inputStream))));
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        } else {
            response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((ByteBuf)Objects.requireNonNull(ByteBufUtil.fileToByteBuf(response1.getFile()))));
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)(MimeType.getFileType(response1.getFileName()) + ";charset=UTF-8"));
        response.headers().add((CharSequence)HttpHeaderNames.CONTENT_DISPOSITION, (Object)String.format("attachment; filename=\"%s\"", response1.getFileName()));
        return response;
    }

    public static FullHttpResponse buildHttpResponseData(Response response1) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, Unpooled.wrappedBuffer((byte[])response1.getResult().getBytes(StandardCharsets.UTF_8)));
        return response;
    }

    public static FullHttpResponse buildEnd(Request request, FullHttpResponse response, Response response1) {
        if (response1.getHttpResponseStatus() != null) {
            response.setStatus(response1.getHttpResponseStatus());
        }
        if (request.getStreamId() != null) {
            response.headers().set((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text(), (Object)request.getStreamId());
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        Map<String, String> headers = response1.getHeaders();
        headers.forEach((a, b) -> {
            response.headers().set(a, b);
            if (a.equalsIgnoreCase("location")) {
                response.setStatus(HttpResponseStatus.FOUND);
            }
        });
        return response;
    }

    public static FullHttpResponse buildString(String res) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        return BuildResponse.getFullHttpResponse(res, httpResponseStatus);
    }

    public static FullHttpResponse buildError(BusinessException e) {
        HttpRequest httpRequest = e.getWebkit().httpRequest;
        BusinessBean build = new BusinessBean();
        build.setArgs(httpRequest.getRequestParams().toString());
        build.setCode(e.getHttpCode());
        build.setErrorDesc(e.getErrorDescription());
        build.setErrorMsg(ExceptionUtil.getHtmlMessage(e.getThrowable()));
        build.setMethod(httpRequest.getRequestType().name());
        build.setUrl(httpRequest.getUri());
        build.setVersion("2.9.84");
        build.setBugAddress("https://gitee.com/HServer/HServer/issues");
        HashMap<String, BusinessBean> data = new HashMap<String, BusinessBean>();
        data.put("business", build);
        String html = "\u6a21\u677f\u8f93\u51fa\u9519\u8bef";
        try {
            html = FreemarkerUtil.getTemplate("hserver_error.ftl", data);
        }
        catch (Exception exception) {
            // empty catch block
        }
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)e.getHttpCode());
        return BuildResponse.getFullHttpResponse(html, httpResponseStatus);
    }

    public static FullHttpResponse buildError(Throwable e) {
        HttpResponseStatus httpResponseStatus = HttpResponseStatus.valueOf((int)HttpResponseStatus.INTERNAL_SERVER_ERROR.code());
        String message = ExceptionUtil.getMessage(e);
        return BuildResponse.getFullHttpResponse(message, httpResponseStatus);
    }

    private static FullHttpResponse getFullHttpResponse(String html, HttpResponseStatus httpResponseStatus) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, httpResponseStatus, Unpooled.wrappedBuffer((byte[])html.getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/html;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        return response;
    }

    public static void writeException(ChannelHandlerContext ctx, Throwable cause) {
        BuildResponse.writeException(ctx, cause, HttpResponseStatus.SERVICE_UNAVAILABLE);
    }

    private static void writeException(ChannelHandlerContext ctx, Throwable cause, HttpResponseStatus status) {
        String message = ExceptionUtil.getMessage(cause);
        message = "HServer:2.9.84\u670d\u52a1\u5668\u5f02\u5e38:\n" + message;
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.wrappedBuffer((byte[])message.getBytes(StandardCharsets.UTF_8)));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain;charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)response.content().readableBytes());
        response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        HServerContextHolder.remove();
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }
}

