/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.HServerApplication;
import top.hserver.core.server.context.HServerContext;
import top.hserver.core.server.context.HServerContextHolder;
import top.hserver.core.server.context.HeadMap;
import top.hserver.core.server.context.Request;
import top.hserver.core.server.context.Response;
import top.hserver.core.server.context.Webkit;
import top.hserver.core.server.handlers.BuildResponse;
import top.hserver.core.server.util.ByteBufUtil;
import top.hserver.core.server.util.HServerIpUtil;
import top.hserver.core.server.util.RequestIdGen;

public class HServerContentHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private static final Logger log = LoggerFactory.getLogger(HServerApplication.class);
    private static final DefaultHttpDataFactory FACTORY = new DefaultHttpDataFactory(16384L);
    private boolean isHttp2 = false;
    public Channel outboundChannel;

    public HServerContentHandler(boolean isHttp2) {
        this.isHttp2 = isHttp2;
    }

    protected void channelRead0(ChannelHandlerContext channelHandlerContext, FullHttpRequest req) throws Exception {
        HServerContext hServerContext = new HServerContext();
        Request request = new Request();
        hServerContext.setRequest(request);
        if (this.isHttp2) {
            String streamId = req.headers().get((CharSequence)HttpConversionUtil.ExtensionHeaderNames.STREAM_ID.text());
            request.setStreamId(streamId);
        }
        request.setHandler(this);
        request.setRequestId(RequestIdGen.getId());
        request.setIp(HServerIpUtil.getClientIp(channelHandlerContext));
        request.setPort(HServerIpUtil.getClientPort(channelHandlerContext));
        request.setCtx(channelHandlerContext);
        request.setNettyUri(req.uri());
        request.setNettyRequest((FullHttpRequest)new DefaultFullHttpRequest(req.protocolVersion(), req.method(), req.uri(), Unpooled.copiedBuffer((ByteBuf)req.content()), req.headers(), req.trailingHeaders()));
        this.handlerUrl(request, req);
        this.handlerBody(request, req);
        int i = req.uri().indexOf("?");
        if (i > 0) {
            String uri = req.uri();
            request.setUri(uri.substring(0, i));
        } else {
            request.setUri(req.uri());
        }
        request.setRequestType(req.method());
        HeadMap headers = new HeadMap();
        req.headers().names().forEach(a -> headers.put((String)a, req.headers().get(a)));
        request.setHeaders(headers);
        hServerContext.setRequest(request);
        hServerContext.setResponse(new Response());
        Webkit webkit = new Webkit();
        webkit.httpRequest = hServerContext.getRequest();
        webkit.httpResponse = hServerContext.getResponse();
        webkit.httpResponse.setHeader("hRequestId", webkit.httpRequest.getRequestId());
        webkit.httpResponse.setHeader("HServer", "2.9.84");
        hServerContext.setWebkit(webkit);
        HServerContextHolder.setWebKit(webkit);
        channelHandlerContext.fireChannelRead((Object)hServerContext);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        BuildResponse.writeException(ctx, cause);
    }

    private void handlerUrl(Request request, FullHttpRequest req) {
        try {
            Map<String, List<String>> requestParams = request.getRequestParams();
            QueryStringDecoder decoder = new QueryStringDecoder(req.uri());
            Map params = decoder.parameters();
            for (Map.Entry next : params.entrySet()) {
                requestParams.put((String)next.getKey(), (List<String>)next.getValue());
                for (String s : (List)next.getValue()) {
                    request.addReqUrlParams((String)next.getKey(), s);
                }
            }
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }

    private void handlerBody(Request request, FullHttpRequest req) {
        ByteBuf body = req.content().duplicate();
        request.setBody(ByteBufUtil.byteBufToBytes(body));
        try {
            HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)FACTORY, (HttpRequest)req);
            List bodyHttpDates = decoder.getBodyHttpDatas();
            bodyHttpDates.forEach(request::writeHttpData);
            decoder.destroy();
        }
        catch (Exception e) {
            log.warn(e.getMessage());
        }
    }
}

