/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import top.hserver.core.server.context.HumMessage;
import top.hserver.core.server.util.HumMessageUtil;

public class Hum {
    private final DatagramPacket datagramPacket;
    private final ChannelHandlerContext ctx;
    private final Type type;

    public Hum(DatagramPacket datagramPacket, ChannelHandlerContext ctx, Type type) {
        this.datagramPacket = datagramPacket;
        this.ctx = ctx;
        this.type = type;
    }

    public boolean isLive() {
        return this.ctx.channel().isActive() && !this.ctx.isRemoved() && this.ctx.channel().isOpen();
    }

    public void sendMessage(HumMessage humMessage) {
        this.ctx.writeAndFlush((Object)new DatagramPacket(HumMessageUtil.createMessage(humMessage), (InetSocketAddress)this.datagramPacket.sender()));
    }

    public Type getType() {
        return this.type;
    }

    public static enum Type {
        CLIENT,
        SERVER;

    }
}

