/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.HumAdapter;
import top.hserver.core.ioc.IocUtil;
import top.hserver.core.server.context.HumMessage;
import top.hserver.core.server.handlers.Hum;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.HumMessageUtil;

public class HumServerHandler
extends SimpleChannelInboundHandler<DatagramPacket> {
    private static final Logger log = LoggerFactory.getLogger(HumServerHandler.class);

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ctx.close();
        log.error(ExceptionUtil.getMessage(cause));
    }

    protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
        HumMessage message = HumMessageUtil.getMessage((ByteBuf)msg.content());
        if (message != null) {
            if ("HServer".equals(message.getType())) {
                log.debug("hum\u6d88\u606f:{}", (Object)message.getData().toString());
            } else {
                List<HumAdapter> listBean = IocUtil.getListBean(HumAdapter.class);
                if (listBean != null) {
                    for (HumAdapter humAdapter : listBean) {
                        humAdapter.message(message, new Hum(msg, ctx, Hum.Type.CLIENT));
                    }
                }
            }
        }
    }
}

