/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.File;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HServerContext;
import top.hserver.core.server.context.StaticFile;
import top.hserver.core.server.exception.BusinessException;

public class StaticHandler {
    private static final String BASE = "static";
    private static final String BASE_PATH = "/static";
    private static final CopyOnWriteArraySet<String> STATIC_FILE_URI = new CopyOnWriteArraySet();

    public StaticFile handler(String uri, HServerContext hServerContext) {
        if (uri.endsWith("/")) {
            uri = uri + "index.html";
        }
        if (!STATIC_FILE_URI.contains(uri)) {
            return null;
        }
        InputStream input = StaticHandler.class.getResourceAsStream(BASE_PATH + uri);
        if (input != null) {
            return this.buildStaticFile(input, uri, hServerContext);
        }
        return null;
    }

    private StaticFile buildStaticFile(InputStream input, String url, HServerContext hServerContext) {
        StaticFile staticFile;
        try {
            int available = input.available();
            staticFile = new StaticFile();
            staticFile.setSize(available);
            int i = url.lastIndexOf("/");
            int i1 = url.lastIndexOf(".");
            if (i <= -1 || i1 <= 0) {
                return null;
            }
            String fileName = url.substring(i + 1, url.length());
            String[] split = fileName.split("\\.");
            staticFile.setFileName(fileName);
            staticFile.setFileType(split[split.length - 1]);
            staticFile.setInputStream(input);
        }
        catch (Exception e) {
            throw new BusinessException(HttpResponseStatus.INTERNAL_SERVER_ERROR.code(), "\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u5f02\u5e38", e, hServerContext.getWebkit());
        }
        return staticFile;
    }

    private static void developFile(String path, int length) {
        File[] files;
        File file = new File(path);
        if (file.exists() && null != (files = file.listFiles())) {
            for (File file2 : files) {
                if (file2.isDirectory()) {
                    StaticHandler.developFile(file2.getAbsolutePath(), length);
                    continue;
                }
                try {
                    URL url = new URL("file:" + file2.getAbsolutePath());
                    STATIC_FILE_URI.add(url.getPath().substring(length));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public static void onlineFile(String path) {
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)new URL(path).openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            Enumeration<JarEntry> entry = jarFile.entries();
            while (entry.hasMoreElements()) {
                JarEntry jar = entry.nextElement();
                String name = jar.getName();
                if (!name.contains(BASE) || name.endsWith("/")) continue;
                STATIC_FILE_URI.add(name.substring(BASE.length()));
            }
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        if (ConstConfig.RUNJAR.booleanValue()) {
            StaticHandler.onlineFile(ConstConfig.CLASSPATH);
        } else {
            String s = ConstConfig.CLASSPATH + BASE_PATH;
            StaticHandler.developFile(s, s.length());
        }
    }
}

