/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.handlers;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.context.WsType;

public class Ws {
    private static final Logger log = LoggerFactory.getLogger(Ws.class);
    private ChannelHandlerContext ctx;
    private String message;
    private byte[] binary;
    private String uid;
    private HttpRequest request;
    private Map<String, List<String>> reqData = new HashMap<String, List<String>>();
    private WsType type;

    public Ws(ChannelHandlerContext ctx, String uid, HttpRequest request, WsType type) {
        this.ctx = ctx;
        this.uid = uid;
        this.request = request;
        this.type = type;
        this.initReqData();
    }

    public Ws(ChannelHandlerContext ctx, String message, String uid, HttpRequest request, WsType type) {
        this.ctx = ctx;
        this.message = message;
        this.uid = uid;
        this.request = request;
        this.type = type;
        this.initReqData();
    }

    public Ws(ChannelHandlerContext ctx, byte[] binary, String uid, HttpRequest request, WsType type) {
        this.ctx = ctx;
        this.binary = binary;
        this.uid = uid;
        this.request = request;
        this.type = type;
        this.initReqData();
    }

    public WsType getType() {
        return this.type;
    }

    public void setType(WsType type) {
        this.type = type;
    }

    public void send(String msg) {
        this.ctx.writeAndFlush((Object)new TextWebSocketFrame(msg));
    }

    public void send(byte[] msg) {
        this.ctx.writeAndFlush((Object)new TextWebSocketFrame(Unpooled.wrappedBuffer((byte[])msg)));
    }

    public void sendBinary(byte[] msg) {
        this.ctx.writeAndFlush((Object)new BinaryWebSocketFrame(Unpooled.wrappedBuffer((byte[])msg)));
    }

    public void sendBinary(ByteBuf msg) {
        this.ctx.writeAndFlush((Object)new BinaryWebSocketFrame(msg));
    }

    public String query(String name) {
        return this.reqData.get(name) != null ? this.reqData.get(name).get(0) : null;
    }

    private void initReqData() {
        if (this.request != null) {
            try {
                QueryStringDecoder decoder = new QueryStringDecoder(this.request.uri());
                Map params = decoder.parameters();
                for (Map.Entry next : params.entrySet()) {
                    this.reqData.put((String)next.getKey(), (List<String>)next.getValue());
                }
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
    }

    public ChannelHandlerContext getCtx() {
        return this.ctx;
    }

    public void setCtx(ChannelHandlerContext ctx) {
        this.ctx = ctx;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public String getUid() {
        return this.uid;
    }

    public void setUid(String uid) {
        this.uid = uid;
    }

    public HttpRequest getRequest() {
        return this.request;
    }

    public void setRequest(HttpRequest request) {
        this.request = request;
    }

    public Map<String, List<String>> getReqData() {
        return this.reqData;
    }

    public void setReqData(Map<String, List<String>> reqData) {
        this.reqData = reqData;
    }

    public byte[] getBinary() {
        return this.binary;
    }

    public void setBinary(byte[] binary) {
        this.binary = binary;
    }
}

