/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.router;

import io.netty.handler.codec.http.HttpMethod;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.ioc.annotation.RequestMethod;
import top.hserver.core.server.context.HServerContext;
import top.hserver.core.server.context.PatternUri;
import top.hserver.core.server.context.Request;
import top.hserver.core.server.router.RouterInfo;
import top.hserver.core.server.router.RouterPermission;
import top.hserver.core.server.util.ExceptionUtil;

public class RouterManager {
    private static final Logger log = LoggerFactory.getLogger(RouterManager.class);
    private static final Map<HttpMethod, Map<String, RouterInfo>> router = new ConcurrentHashMap<HttpMethod, Map<String, RouterInfo>>();
    private static final Map<HttpMethod, Map<String, RouterPermission>> routerPermission = new ConcurrentHashMap<HttpMethod, Map<String, RouterPermission>>();
    private static final Map<HttpMethod, Map<String, PatternUri>> ISPAURI = new ConcurrentHashMap<HttpMethod, Map<String, PatternUri>>();

    public static synchronized void clearRouterManager() {
        router.clear();
        routerPermission.clear();
    }

    private static Map<String, PatternUri> ISPAURI(HttpMethod method) {
        Map<String, PatternUri> stringPatternUriMap = ISPAURI.get(method);
        if (stringPatternUriMap == null) {
            stringPatternUriMap = new ConcurrentHashMap<String, PatternUri>();
            ISPAURI.put(method, stringPatternUriMap);
        }
        return stringPatternUriMap;
    }

    private static Map<String, RouterPermission> routerPermission(HttpMethod method) {
        Map<String, RouterPermission> stringRouterPermissionMap = routerPermission.get(method);
        if (stringRouterPermissionMap == null) {
            stringRouterPermissionMap = new ConcurrentHashMap<String, RouterPermission>();
            routerPermission.put(method, stringRouterPermissionMap);
        }
        return stringRouterPermissionMap;
    }

    private static Map<String, RouterInfo> router(HttpMethod method) {
        Map<String, RouterInfo> stringRouterInfoMap = router.get(method);
        if (stringRouterInfoMap == null) {
            stringRouterInfoMap = new ConcurrentHashMap<String, RouterInfo>();
            router.put(method, stringRouterInfoMap);
        }
        return stringRouterInfoMap;
    }

    public static void addRouter(RouterInfo routerInfo) {
        if (routerInfo != null) {
            Map<String, RouterInfo> router;
            String url = routerInfo.getUrl();
            List<String> pattern = RouterManager.isPattern(url);
            if (pattern.size() > 0) {
                String s = url;
                for (int i = 0; i < pattern.size(); ++i) {
                    s = i == pattern.size() - 1 ? s.replaceAll("\\{" + pattern.get(i) + "\\}", "(.+)") : s.replaceAll("\\{" + pattern.get(i) + "\\}", "(.+?)");
                }
                Map<String, PatternUri> ispauri = RouterManager.ISPAURI(routerInfo.getReqMethodName());
                if (ispauri != null) {
                    s = "^" + s;
                    ispauri.put(s, new PatternUri(pattern, url, s));
                }
            }
            if ((router = RouterManager.router(routerInfo.getReqMethodName())) != null) {
                if (router.containsKey(url)) {
                    log.warn("url< {} >\u6620\u5c04\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528", (Object)url);
                }
                router.put(url, routerInfo);
            }
        }
    }

    private static List<String> isPattern(String url) {
        String regex = "(\\{.*?\\})";
        Matcher matcher = Pattern.compile(regex).matcher(url);
        ArrayList<String> patterns = new ArrayList<String>();
        while (matcher.find()) {
            String group = matcher.group(1);
            if (group == null) continue;
            patterns.add(group.substring(1, group.length() - 1));
        }
        return patterns;
    }

    private static PatternUri isPattern(String url, HttpMethod method) {
        Map<String, PatternUri> ispauri = RouterManager.ISPAURI(method);
        if (ispauri == null) {
            return null;
        }
        for (String next : ispauri.keySet()) {
            if (!Pattern.compile(next).matcher(url).find()) continue;
            return ispauri.get(next);
        }
        return null;
    }

    public static void addPermission(RouterPermission routerPermission) {
        if (routerPermission != null) {
            String url = routerPermission.getUrl();
            Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(routerPermission.getReqMethodName());
            if (stringRouterPermissionMap != null) {
                if (stringRouterPermissionMap.containsKey(url)) {
                    log.warn("url< {} >\u6743\u9650\u6620\u5c04\u5df2\u7ecf\u5b58\u5728\uff0c\u53ef\u80fd\u4f1a\u5f71\u54cd\u7a0b\u5e8f\u4f7f\u7528", (Object)url);
                }
                stringRouterPermissionMap.put(url, routerPermission);
            }
        }
    }

    public static RouterInfo getRouterInfo(String url, HttpMethod requestType, HServerContext hServerContext) {
        Request request = hServerContext.getRequest();
        Map<String, RouterInfo> router = RouterManager.router(requestType);
        if (router == null) {
            return null;
        }
        RouterInfo routerInfo = router.get(url);
        if (routerInfo != null) {
            return routerInfo;
        }
        PatternUri pattern = RouterManager.isPattern(url, requestType);
        if (pattern != null) {
            Matcher matcher = Pattern.compile(pattern.getPatternUrl()).matcher(url);
            if (matcher.find()) {
                for (int i = 0; i < pattern.getKeys().size(); ++i) {
                    try {
                        request.addReqParams(pattern.getKeys().get(i), URLDecoder.decode(matcher.group(i + 1), "UTF-8"));
                        request.addReqUrlParams(pattern.getKeys().get(i), URLDecoder.decode(matcher.group(i + 1), "UTF-8"));
                        continue;
                    }
                    catch (UnsupportedEncodingException e) {
                        log.error(ExceptionUtil.getMessage(e));
                    }
                }
            }
            return router.get(pattern.getOrgUrl());
        }
        return null;
    }

    public static RouterPermission getRouterPermission(String url, HttpMethod requestType) {
        Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(requestType);
        if (stringRouterPermissionMap == null) {
            return null;
        }
        RouterPermission routerPermission = stringRouterPermissionMap.get(url);
        if (routerPermission != null) {
            return routerPermission;
        }
        PatternUri pattern = RouterManager.isPattern(url, requestType);
        if (pattern != null) {
            return stringRouterPermissionMap.get(pattern.getOrgUrl());
        }
        return null;
    }

    public static List<RouterPermission> getRouterPermissions() {
        String[] requestMethodAll;
        ArrayList<RouterPermission> permissions = new ArrayList<RouterPermission>();
        for (String s : requestMethodAll = RequestMethod.getRequestMethodAll()) {
            HttpMethod httpMethod = HttpMethod.valueOf((String)s);
            Map<String, RouterPermission> stringRouterPermissionMap = RouterManager.routerPermission(httpMethod);
            if (stringRouterPermissionMap == null) continue;
            stringRouterPermissionMap.forEach((a, b) -> permissions.add((RouterPermission)b));
        }
        return permissions;
    }
}

