/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.File;
import java.net.URI;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import top.hserver.core.server.context.ConstConfig;

public class EnvironmentUtil {
    public static void init(Class clazz) throws Exception {
        String path;
        if (clazz != null) {
            File f = new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
            ConstConfig.RUNJAR = false;
            ConstConfig.CLASSPATH = f.getPath();
            return;
        }
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Class<?> aClass = null;
        for (StackTraceElement stackTraceElement : stackTrace) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            try {
                aClass = Class.forName(stackTraceElement.getClassName());
                break;
            }
            catch (Exception e) {
                return;
            }
        }
        if (aClass == null) {
            return;
        }
        ProtectionDomain protectionDomain = aClass.getProtectionDomain();
        CodeSource codeSource = protectionDomain.getCodeSource();
        URI location = codeSource == null ? null : codeSource.getLocation().toURI();
        String string = path = location == null ? null : location.getSchemeSpecificPart();
        if (path != null && (path.endsWith(".jar") || path.endsWith(".jar!/"))) {
            ConstConfig.RUNJAR = true;
            if (!path.startsWith("file")) {
                path = "file:" + path;
            }
            if (!path.endsWith(".jar!/")) {
                path = path + "!/";
            }
            ConstConfig.CLASSPATH = "jar:" + path;
        } else {
            ConstConfig.CLASSPATH = new File(aClass.getProtectionDomain().getCodeSource().getLocation().toURI().getPath()).getPath();
            ConstConfig.RUNJAR = false;
        }
    }
}

