/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import java.nio.charset.Charset;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullHttpMessageUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullHttpMessageUtil.class);
    private static final String LINE_SEPARATOR = "\r\n";
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public static MessageLogger log(FullHttpRequest request) {
        return new MessageLogger(LOGGER, request);
    }

    public static MessageLogger log(FullHttpResponse response) {
        return new MessageLogger(LOGGER, response);
    }

    public static final class MessageLogger {
        private Logger logger;
        private String line;
        private Object[] firstLine;
        private HttpHeaders headers;
        private String content;

        public MessageLogger(Logger logger, FullHttpRequest request) {
            this.logger = logger;
            this.line = "------------------ request " + request.method() + "  ------------------";
            this.firstLine = new Object[]{request.getMethod(), request.getUri(), request.getProtocolVersion()};
            this.headers = request.headers();
            this.content = request.content().toString(UTF_8);
        }

        public MessageLogger(Logger logger, FullHttpResponse response) {
            this.logger = logger;
            this.line = "------------------ response ------------------";
            this.firstLine = new Object[]{response.getProtocolVersion(), response.getStatus().code(), response.getStatus().reasonPhrase()};
            this.headers = response.headers();
            this.content = response.content().toString(UTF_8);
        }

        public void debug() {
            this.logger.debug(this.line);
            this.logger.debug("{} {} {}", this.firstLine);
            for (Map.Entry entry : this.headers) {
                this.logger.debug("{}:{}", entry.getKey(), entry.getValue());
            }
            this.logger.debug("");
            this.logger.debug("{}", (Object)(this.content == null || this.content.length() == 0 ? "[no-content]" : this.content));
            this.logger.debug("<<<");
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.firstLine.length; ++i) {
                if (0 != i) {
                    buf.append(" ");
                }
                buf.append(this.firstLine[i]);
            }
            buf.append(FullHttpMessageUtil.LINE_SEPARATOR);
            for (Map.Entry entry : this.headers) {
                buf.append((String)entry.getKey()).append(":").append((String)entry.getValue()).append(FullHttpMessageUtil.LINE_SEPARATOR);
            }
            buf.append(FullHttpMessageUtil.LINE_SEPARATOR);
            buf.append(this.content == null || this.content.length() == 0 ? "[no-content]" : this.content);
            buf.append(FullHttpMessageUtil.LINE_SEPARATOR).append("<<<<<<<<<<.");
            return buf.toString();
        }
    }
}

