/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.File;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarFile;
import top.hserver.core.server.context.ConstConfig;

public class PackageUtil {
    public static Set<String> scanPackage() {
        if (ConstConfig.RUNJAR.booleanValue()) {
            return PackageUtil.onlineFile(ConstConfig.CLASSPATH);
        }
        if (ConstConfig.CLASSPATH.endsWith("test-classes")) {
            Set<String> strings = PackageUtil.developFile(ConstConfig.CLASSPATH);
            Set<String> strings1 = PackageUtil.developFile(ConstConfig.CLASSPATH.replaceAll("test-classes", "classes"));
            strings.addAll(strings1);
            return strings;
        }
        return PackageUtil.developFile(ConstConfig.CLASSPATH);
    }

    private static Set<String> developFile(String path) {
        File[] files;
        HashSet<String> tmp = new HashSet<String>();
        File file = new File(path);
        if (file.exists() && null != (files = file.listFiles())) {
            for (File file2 : files) {
                if (!file2.isDirectory()) continue;
                tmp.add(file2.getPath().substring(path.length() + 1));
            }
        }
        return tmp;
    }

    private static Set<String> onlineFile(String path) {
        HashSet<String> tmp = new HashSet<String>();
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)new URL(path).openConnection();
            JarFile jarFile = jarURLConnection.getJarFile();
            jarFile.stream().forEach(jarEntry -> {
                try {
                    String name = jarEntry.getName();
                    tmp.add(name.substring(0, name.indexOf("/")));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            jarFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tmp;
    }
}

