/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javassist.ClassClassPath;
import javassist.ClassPath;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.MethodInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.HttpRequest;
import top.hserver.core.interfaces.HttpResponse;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HServerContext;
import top.hserver.core.server.context.MimeType;
import top.hserver.core.server.exception.ValidateException;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.ValidateUtil;

public class ParameterUtil {
    private static final Logger log = LoggerFactory.getLogger(ParameterUtil.class);
    private static final ConcurrentHashMap<Class, ConcurrentHashMap<Method, String[]>> PARAM_NAME_MAP = new ConcurrentHashMap();

    public static Object[] getMethodArgs(Class cs, Method method, HServerContext hServerContext) throws Exception {
        Parameter[] parameterTypes = method.getParameters();
        if (parameterTypes.length == 0) {
            return null;
        }
        Object[] objects = new Object[parameterTypes.length];
        String[] strings = PARAM_NAME_MAP.get(cs).get(method);
        if (parameterTypes.length != strings.length) {
            throw new Exception(method.getName() + "-\u65b9\u6cd5\u53c2\u6570\u83b7\u53d6\u5f02\u5e38");
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (parameterTypes[i].getParameterizedType() == HttpRequest.class) {
                objects[i] = hServerContext.getRequest();
                continue;
            }
            if (parameterTypes[i].getParameterizedType() == HttpResponse.class) {
                objects[i] = hServerContext.getResponse();
                continue;
            }
            Parameter parameterType = parameterTypes[i];
            String typeName = strings[i];
            Map<String, List<String>> requestParams = hServerContext.getRequest().getRequestParams();
            try {
                Object convert = ParameterUtil.convert(parameterType.getType(), requestParams.get(typeName) == null ? null : requestParams.get(typeName).get(0));
                if (convert != null) {
                    objects[i] = convert;
                    continue;
                }
                String type = hServerContext.getRequest().getHeader(HttpHeaderNames.CONTENT_TYPE.toString());
                if (type != null && type.contains(MimeType.get("json"))) {
                    String rawData = hServerContext.getRequest().getRawData();
                    if (rawData != null) {
                        objects[i] = ConstConfig.JSONADAPTER.convertObject(rawData, parameterType);
                    }
                } else if (requestParams.size() > 0) {
                    objects[i] = ConstConfig.JSONADAPTER.convertMapToObject(ParameterUtil.invokeData(requestParams), parameterType.getType());
                }
                ValidateUtil.validate(objects[i]);
                continue;
            }
            catch (Exception e) {
                if (!(e instanceof ValidateException)) continue;
                throw e;
            }
        }
        return objects;
    }

    private static Map<String, String> invokeData(Map<String, List<String>> requestParams) {
        ConcurrentHashMap<String, String> data = new ConcurrentHashMap<String, String>();
        requestParams.forEach((k, v) -> {
            if (k != null && v.size() > 0) {
                data.put((String)k, (String)v.get(0));
            }
        });
        return data;
    }

    private static String[] getParamNames(Method method) {
        try {
            Class<?> clazz = method.getDeclaringClass();
            ClassPool pool = ClassPool.getDefault();
            CtClass clz = pool.get(clazz.getName());
            clz.freeze();
            clz.defrost();
            CtClass[] params = new CtClass[method.getParameterTypes().length];
            for (int i = 0; i < method.getParameterTypes().length; ++i) {
                ClassClassPath classPath = new ClassClassPath(method.getParameterTypes()[i]);
                pool.insertClassPath((ClassPath)classPath);
                params[i] = pool.getCtClass(method.getParameterTypes()[i].getName());
            }
            CtMethod cm = clz.getDeclaredMethod(method.getName(), params);
            MethodInfo methodInfo = cm.getMethodInfo();
            CodeAttribute codeAttribute = methodInfo.getCodeAttribute();
            LocalVariableAttribute attr = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
            int pos = Modifier.isStatic(cm.getModifiers()) ? 0 : 1;
            String[] paramNames = new String[cm.getParameterTypes().length];
            for (int i = 0; i < attr.tableLength(); ++i) {
                if (attr.index(i) < pos || attr.index(i) >= paramNames.length + pos) continue;
                paramNames[attr.index((int)i) - pos] = attr.variableName(i);
            }
            return paramNames;
        }
        catch (NotFoundException e) {
            log.error(ExceptionUtil.getMessage(e));
            return new String[0];
        }
    }

    public static void addParam(Class cs, Method method) throws Exception {
        String[] paramNames = ParameterUtil.getParamNames(method);
        if (method.getParameterTypes().length == paramNames.length) {
            if (PARAM_NAME_MAP.containsKey(cs)) {
                ConcurrentHashMap<Method, String[]> concurrentHashMap = PARAM_NAME_MAP.get(cs);
                concurrentHashMap.put(method, paramNames);
                PARAM_NAME_MAP.put(cs, concurrentHashMap);
            } else {
                ConcurrentHashMap<Method, String[]> concurrentHashMap = new ConcurrentHashMap<Method, String[]>();
                concurrentHashMap.put(method, paramNames);
                PARAM_NAME_MAP.put(cs, concurrentHashMap);
            }
        } else {
            throw new Exception("\u53c2\u6570\u5f02\u5e38");
        }
    }

    public static Object convert(Class<?> type, String res) {
        Object object = null;
        try {
            switch (type.getName()) {
                case "int": {
                    if (res == null) {
                        object = 0;
                        break;
                    }
                    object = Integer.parseInt(res);
                    break;
                }
                case "java.lang.Integer": {
                    object = Integer.parseInt(res);
                    break;
                }
                case "double": {
                    if (res == null) {
                        object = 0.0;
                        break;
                    }
                    object = Double.parseDouble(res);
                    break;
                }
                case "java.lang.Double": {
                    object = Double.parseDouble(res);
                    break;
                }
                case "long": {
                    if (res == null) {
                        object = 0L;
                        break;
                    }
                    object = Long.parseLong(res);
                    break;
                }
                case "java.lang.Long": {
                    object = Long.parseLong(res);
                    break;
                }
                case "short": {
                    if (res == null) {
                        object = 0;
                        break;
                    }
                    object = Short.parseShort(res);
                    break;
                }
                case "java.lang.Short": {
                    object = Short.parseShort(res);
                    break;
                }
                case "float": {
                    if (res == null) {
                        object = 0;
                        break;
                    }
                    object = Float.valueOf(Float.parseFloat(res));
                    break;
                }
                case "java.lang.Float": {
                    object = Float.valueOf(Float.parseFloat(res));
                    break;
                }
                case "boolean": {
                    if (res == null) {
                        object = false;
                        break;
                    }
                    object = Boolean.parseBoolean(res);
                    break;
                }
                case "java.lang.Boolean": {
                    object = Boolean.parseBoolean(res);
                    break;
                }
                case "byte": {
                    if (res == null) {
                        object = false;
                        break;
                    }
                    object = Byte.parseByte(res);
                    break;
                }
                case "java.lang.Byte": {
                    object = Byte.parseByte(res);
                    break;
                }
                case "java.lang.BigInteger": {
                    object = BigInteger.valueOf(Long.parseLong(res));
                    break;
                }
                case "java.lang.BigDecimal": {
                    object = BigDecimal.valueOf(Long.parseLong(res));
                    break;
                }
                case "java.lang.String": {
                    object = res;
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return object;
    }
}

