/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.context.HeadMap;
import top.hserver.core.server.util.ExceptionUtil;

public class PropUtil {
    private static final Logger log = LoggerFactory.getLogger(PropUtil.class);
    private static PropUtil propUtil;
    private static final HeadMap data;

    private PropUtil() {
    }

    public static PropUtil getInstance() {
        if (propUtil != null) {
            return propUtil;
        }
        propUtil = new PropUtil();
        PropUtil.initProp();
        return propUtil;
    }

    private static String getProFiles(String name) {
        return name == null ? null : "/app-" + name + ".properties";
    }

    private static void initProp() {
        Properties p = new Properties();
        try {
            String name = "/app.properties";
            InputStreamReader is = PropUtil.getFileStream(name);
            if (is == null) {
                return;
            }
            p.load(is);
            p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> data.put(k.toString(), v.toString())));
            is.close();
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
        if (ConstConfig.profiles == null) {
            ConstConfig.profiles = data.get("env");
        }
        if (ConstConfig.profiles != null) {
            try {
                InputStreamReader is2 = PropUtil.getFileStream(PropUtil.getProFiles(ConstConfig.profiles));
                p.clear();
                if (is2 == null) {
                    return;
                }
                p.load(is2);
                p.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> data.put(k.toString(), v.toString())));
                is2.close();
                p.clear();
            }
            catch (Exception e) {
                log.error(ExceptionUtil.getMessage(e));
            }
        }
    }

    public String get(String key) {
        String property = data.get(key);
        return property == null ? "" : property;
    }

    public String get(String key, String defaultValue) {
        String value = this.get(key.trim());
        if (this.isBlank(value)) {
            value = defaultValue;
        }
        return value == null ? value : value.trim();
    }

    public Integer getInt(String key) {
        String s = this.get(key);
        if (s != null && s.trim().length() > 0) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public Boolean getBoolean(String key) {
        String s = this.get(key);
        if (s != null && s.trim().length() > 0) {
            try {
                return Boolean.valueOf(s);
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static InputStreamReader getFileStream(String path) {
        String rootPath = System.getProperty("user.dir");
        try {
            return new InputStreamReader((InputStream)new FileInputStream(rootPath + path), StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            try {
                return new InputStreamReader(PropUtil.class.getResourceAsStream(path), StandardCharsets.UTF_8);
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    static {
        data = new HeadMap();
    }
}

