/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import com.dyuproject.protostuff.Input;
import com.dyuproject.protostuff.LinkedBuffer;
import com.dyuproject.protostuff.ProtostuffIOUtil;
import com.dyuproject.protostuff.Schema;
import com.dyuproject.protostuff.runtime.RuntimeSchema;
import java.util.concurrent.ConcurrentHashMap;
import org.objenesis.Objenesis;
import org.objenesis.ObjenesisStd;

public class SerializationUtil {
    private static ConcurrentHashMap cachedSchema = new ConcurrentHashMap();
    private static Objenesis objenesis = new ObjenesisStd();

    private SerializationUtil() {
    }

    public static <T> byte[] serialize(T obj) {
        Class<?> cls = obj.getClass();
        LinkedBuffer buffer = LinkedBuffer.allocate((int)512);
        try {
            Schema<?> schema = SerializationUtil.getSchema(cls);
            byte[] byArray = ProtostuffIOUtil.toByteArray(obj, schema, (LinkedBuffer)buffer);
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        finally {
            buffer.clear();
        }
    }

    public static <T> T deserialize(byte[] data, Class<T> cls) {
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = SerializationUtil.getSchema(cls);
            ProtostuffIOUtil.mergeFrom((byte[])data, (Object)message, schema);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public static <T> T deserialize(Input in, Class<T> cls) {
        try {
            Object message = objenesis.newInstance(cls);
            Schema<T> schema = SerializationUtil.getSchema(cls);
            schema.mergeFrom(in, message);
            return (T)message;
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private static <T> Schema<T> getSchema(Class<T> cls) {
        Schema schema = (Schema)cachedSchema.get(cls);
        if (schema == null) {
            schema = RuntimeSchema.createFrom(cls);
            cachedSchema.put(cls, schema);
        }
        return schema;
    }
}

