/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import io.netty.util.concurrent.FastThreadLocal;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.SnowflakeIdWorker;

public class SpanUtil {
    private static final Logger log = LoggerFactory.getLogger(SpanUtil.class);
    private static final SnowflakeIdWorker SNOWFLAKE_ID_WORKER = new SnowflakeIdWorker(1L, 30L);
    private static final FastThreadLocal<Stack<Long>> threadMethods = new FastThreadLocal();

    public static void add() {
        Stack queue;
        if (null == threadMethods.get()) {
            queue = new Stack();
            queue.add(SNOWFLAKE_ID_WORKER.nextId());
        } else {
            queue = (Stack)threadMethods.get();
            queue.add((Long)queue.peek() + 1L);
        }
        threadMethods.set((Object)queue);
    }

    public static long get() {
        try {
            Stack integers = (Stack)threadMethods.get();
            if (integers == null) {
                return SNOWFLAKE_ID_WORKER.nextId();
            }
            return (Long)integers.peek();
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
            return -1L;
        }
    }

    public static void clear() {
        Stack queue = (Stack)threadMethods.get();
        if (queue == null) {
            return;
        }
        queue.pop();
        if (queue.isEmpty()) {
            threadMethods.remove();
        }
    }
}

