/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import io.netty.handler.codec.http2.Http2SecurityUtil;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.server.HServer;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.JettyTlsUtil;
import top.hserver.core.server.util.PropUtil;

public class SslContextUtil {
    private static final Logger log = LoggerFactory.getLogger(SslContextUtil.class);
    static final List<String> NEXT_PROTOCOL_VERSIONS = Collections.unmodifiableList(Arrays.asList("h2", "http/1.1"));
    private static final ApplicationProtocolConfig ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);
    private static final ApplicationProtocolConfig NPN_AND_ALPN = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.NPN_AND_ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, NEXT_PROTOCOL_VERSIONS);

    private static SslProvider defaultSslProvider() {
        return OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
    }

    private static ApplicationProtocolConfig selectApplicationProtocolConfig(SslProvider provider) {
        switch (provider) {
            case JDK: {
                if (JettyTlsUtil.isJettyAlpnConfigured()) {
                    return ALPN;
                }
                if (JettyTlsUtil.isJettyNpnConfigured()) {
                    return NPN;
                }
                throw new IllegalArgumentException("Jetty ALPN/NPN has not been properly configured.");
            }
            case OPENSSL: {
                if (!OpenSsl.isAvailable()) {
                    throw new IllegalArgumentException("OpenSSL is not installed on the system.");
                }
                if (OpenSsl.isAlpnSupported()) {
                    return NPN_AND_ALPN;
                }
                return NPN;
            }
        }
        throw new IllegalArgumentException("Unsupported provider: " + provider);
    }

    public static void setSsl() {
        PropUtil instance = PropUtil.getInstance();
        String certFilePath = instance.get("certPath");
        String privateKeyPath = instance.get("privateKeyPath");
        String privateKeyPwd = instance.get("privateKeyPwd");
        if (privateKeyPath == null || certFilePath == null || privateKeyPath.trim().length() == 0 || certFilePath.trim().length() == 0) {
            return;
        }
        try {
            File cfile = new File(certFilePath);
            File pfile = new File(privateKeyPath);
            if (cfile.isFile() && pfile.isFile()) {
                SslContextBuilder sslContext = SslContextBuilder.forServer((File)cfile, (File)pfile, (String)privateKeyPwd).sslProvider(SslContextUtil.defaultSslProvider());
                if (ConstConfig.openHttp2.booleanValue()) {
                    sslContext.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                    sslContext.applicationProtocolConfig(SslContextUtil.selectApplicationProtocolConfig(SslContextUtil.defaultSslProvider()));
                }
                ConstConfig.sslContext = sslContext.build();
                return;
            }
            InputStream cinput = HServer.class.getResourceAsStream("/ssl/" + certFilePath);
            InputStream pinput = HServer.class.getResourceAsStream("/ssl/" + privateKeyPath);
            if (cinput != null && pinput != null) {
                SslContextBuilder sslContext = SslContextBuilder.forServer((InputStream)cinput, (InputStream)pinput, (String)privateKeyPwd).sslProvider(SslContextUtil.defaultSslProvider());
                if (ConstConfig.openHttp2.booleanValue()) {
                    sslContext.ciphers((Iterable)Http2SecurityUtil.CIPHERS, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE);
                    sslContext.applicationProtocolConfig(SslContextUtil.selectApplicationProtocolConfig(SslContextUtil.defaultSslProvider()));
                }
                ConstConfig.sslContext = sslContext.build();
                cinput.close();
                pinput.close();
            }
        }
        catch (Exception s) {
            log.error(ExceptionUtil.getMessage(s));
        }
    }
}

