/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.server.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Pattern;
import top.hserver.core.ioc.annotation.validate.AssertFalse;
import top.hserver.core.ioc.annotation.validate.AssertTrue;
import top.hserver.core.ioc.annotation.validate.Length;
import top.hserver.core.ioc.annotation.validate.Max;
import top.hserver.core.ioc.annotation.validate.Min;
import top.hserver.core.ioc.annotation.validate.NotBlank;
import top.hserver.core.ioc.annotation.validate.NotEmpty;
import top.hserver.core.ioc.annotation.validate.NotNull;
import top.hserver.core.ioc.annotation.validate.Null;
import top.hserver.core.ioc.annotation.validate.Size;
import top.hserver.core.server.exception.ValidateException;

public class ValidateUtil {
    public static void validate(Object object) throws ValidateException {
        if (object == null) {
            return;
        }
        try {
            Field[] fields = object.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                fields[i].setAccessible(true);
                Object obj = fields[i].get(object);
                ValidateUtil.nullValidate(fields[i], obj);
                ValidateUtil.notNull(fields[i], obj);
                ValidateUtil.notEmpty(fields[i], obj);
                ValidateUtil.notBlank(fields[i], obj);
                ValidateUtil.assertFalse(fields[i], obj);
                ValidateUtil.assertTrue(fields[i], obj);
                ValidateUtil.lengthValidate(fields[i], obj);
                ValidateUtil.max(fields[i], obj);
                ValidateUtil.min(fields[i], obj);
                ValidateUtil.pattern(fields[i], obj);
                ValidateUtil.sizeValidate(fields[i], obj);
            }
        }
        catch (Exception e) {
            throw new ValidateException(e.getMessage());
        }
    }

    private static void assertFalse(Field field, Object obj) throws ValidateException {
        AssertFalse assertFalse = field.getAnnotation(AssertFalse.class);
        if (assertFalse != null) {
            if (obj == null) {
                throw new ValidateException(assertFalse.message(), field, obj);
            }
            if (Boolean.parseBoolean(obj.toString())) {
                throw new ValidateException(assertFalse.message(), field, obj);
            }
        }
    }

    private static void assertTrue(Field field, Object obj) throws ValidateException {
        AssertTrue assertTrue = field.getAnnotation(AssertTrue.class);
        if (assertTrue != null) {
            if (obj == null) {
                throw new ValidateException(assertTrue.message(), field, obj);
            }
            if (!Boolean.parseBoolean(obj.toString())) {
                throw new ValidateException(assertTrue.message(), field, obj);
            }
        }
    }

    private static void lengthValidate(Field field, Object obj) throws ValidateException {
        Length length = field.getAnnotation(Length.class);
        if (length != null) {
            CharSequence obj1;
            if (obj == null) {
                throw new ValidateException(length.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && (long)(obj1 = (CharSequence)obj).length() != length.value()) {
                throw new ValidateException(length.message(), field, obj);
            }
        }
    }

    private static void max(Field field, Object obj) throws ValidateException {
        Max max = field.getAnnotation(Max.class);
        if (max != null && (obj == null || Long.parseLong(obj.toString()) < max.value())) {
            throw new ValidateException(max.message(), field, obj);
        }
    }

    private static void min(Field field, Object obj) throws ValidateException {
        Min min = field.getAnnotation(Min.class);
        if (min != null && (obj == null || Long.parseLong(obj.toString()) > min.value())) {
            throw new ValidateException(min.message(), field, obj);
        }
    }

    private static void notBlank(Field field, Object obj) throws ValidateException {
        NotBlank notBlank = field.getAnnotation(NotBlank.class);
        if (notBlank != null && (obj == null || obj.toString().trim().length() == 0)) {
            throw new ValidateException(notBlank.message(), field, obj);
        }
    }

    private static void notEmpty(Field field, Object obj) throws ValidateException {
        NotEmpty notEmpty = field.getAnnotation(NotEmpty.class);
        if (notEmpty != null) {
            if (obj == null) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && ((CharSequence)obj).length() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (Collection.class.isAssignableFrom(field.getType()) && ((Collection)obj).size() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (Map.class.isAssignableFrom(field.getType()) && ((Map)obj).size() == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
            if (field.getType().isArray() && ((Object[])obj).length == 0) {
                throw new ValidateException(notEmpty.message(), field, obj);
            }
        }
    }

    private static void notNull(Field field, Object obj) throws ValidateException {
        NotNull notNull = field.getAnnotation(NotNull.class);
        if (notNull != null && obj == null) {
            throw new ValidateException(notNull.message(), field, obj);
        }
    }

    private static void nullValidate(Field field, Object obj) throws ValidateException {
        Null isNull = field.getAnnotation(Null.class);
        if (isNull != null && obj != null) {
            throw new ValidateException(isNull.message(), field, obj);
        }
    }

    private static void pattern(Field field, Object obj) throws ValidateException {
        top.hserver.core.ioc.annotation.validate.Pattern pattern = field.getAnnotation(top.hserver.core.ioc.annotation.validate.Pattern.class);
        if (pattern != null) {
            if (obj == null) {
                throw new ValidateException(pattern.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && !Pattern.matches(pattern.value(), obj.toString())) {
                throw new ValidateException(pattern.message(), field, obj);
            }
        }
    }

    private static void sizeValidate(Field field, Object obj) throws ValidateException {
        Size size = field.getAnnotation(Size.class);
        if (size != null) {
            int length;
            if (obj == null) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (CharSequence.class.isAssignableFrom(field.getType()) && ((long)(length = ((CharSequence)obj).length()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (Collection.class.isAssignableFrom(field.getType()) && ((long)(length = ((Collection)obj).size()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (Map.class.isAssignableFrom(field.getType()) && ((long)(length = ((Map)obj).size()) < size.min() || (long)length > size.max())) {
                throw new ValidateException(size.message(), field, obj);
            }
            if (field.getType().isArray()) {
                assert (obj instanceof Object[]);
                length = ((Object[])obj).length;
                if ((long)length < size.min() || (long)length > size.max()) {
                    throw new ValidateException(size.message(), field, obj);
                }
            }
        }
    }
}

