/*
 * Decompiled with CFR 0.152.
 */
package top.hserver.core.task;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.hserver.core.interfaces.TaskJob;
import top.hserver.core.server.context.ConstConfig;
import top.hserver.core.server.util.ExceptionUtil;
import top.hserver.core.server.util.NamedThreadFactory;
import top.hserver.core.task.CronExpression;
import top.hserver.core.task.ScheduledThreadPoolExecutorPro;

public class TaskManager {
    private static final Logger log = LoggerFactory.getLogger(TaskManager.class);
    public static Boolean IS_OK = false;
    private static final Map<String, ScheduledFuture<?>> CRON_TASK = new ConcurrentHashMap();
    private static final ScheduledThreadPoolExecutorPro SCHEDULED_THREAD_POOL_EXECUTOR = new ScheduledThreadPoolExecutorPro((int)ConstConfig.taskPool, new NamedThreadFactory("hserver_task"));

    public static void addTask(String name, String time, Class<? extends TaskJob> taskJob, Object ... args) {
        try {
            if (CRON_TASK.containsKey(name)) {
                log.warn("{}\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)name);
                return;
            }
            TaskJob taskJob1 = taskJob.newInstance();
            try {
                CronExpression expression = new CronExpression(time);
                ScheduledFuture submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit(expression, taskJob1, args);
                CRON_TASK.put(name, submit);
            }
            catch (Exception e) {
                try {
                    int times = Integer.parseInt(time);
                    ScheduledFuture submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit((Integer)times, taskJob1, args);
                    CRON_TASK.put(name, submit);
                }
                catch (Exception e2) {
                    log.error(ExceptionUtil.getMessage(e2));
                }
            }
        }
        catch (Exception e) {
            log.error(ExceptionUtil.getMessage(e));
        }
    }

    public static Set<String> getAllTaskName() {
        return CRON_TASK.keySet();
    }

    public static boolean removeTask(String name) {
        boolean cancel;
        ScheduledFuture<?> scheduledFuture = CRON_TASK.get(name);
        if (scheduledFuture != null && (cancel = scheduledFuture.cancel(true))) {
            CRON_TASK.remove(name);
            return true;
        }
        return false;
    }

    public static boolean existTask(String name) {
        return CRON_TASK.containsKey(name);
    }

    public static void initTask(String name, String time, String className, Method method, Object ... args) {
        if (CRON_TASK.containsKey(name)) {
            log.warn("{}\u4efb\u52a1\u540d\u5df2\u7ecf\u5b58\u5728", (Object)name);
            return;
        }
        try {
            CronExpression expression = new CronExpression(time);
            ScheduledFuture submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit(expression, className, method, args);
            CRON_TASK.put(name, submit);
        }
        catch (Exception e) {
            try {
                int times = Integer.parseInt(time);
                ScheduledFuture submit = SCHEDULED_THREAD_POOL_EXECUTOR.submit((Integer)times, className, method, args);
                CRON_TASK.put(name, submit);
            }
            catch (Exception e1) {
                log.error(ExceptionUtil.getMessage(e1));
            }
        }
    }
}

