package top.jcsun.breeze.config;

import cn.hutool.core.text.CharSequenceUtil;
import cn.hutool.extra.spring.SpringUtil;
import cn.hutool.system.SystemUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;

import java.net.UnknownHostException;

/**
 * @author jcsun
 */
@Slf4j
@ConditionalOnMissingBean(InitializeRunner.class)
public class InitializeRunner implements ApplicationRunner {

    @Override
    public void run(ApplicationArguments args) {
        try {
            printAccessAddress();
        } catch (UnknownHostException e) {
            log.error("无法获取主机地址: {}", e.getMessage());
        }
    }

    private void printAccessAddress() throws UnknownHostException {
        log.info("");
        log.info("==== 系统信息 ====");
        log.info("操作系统: {}", SystemUtil.getOsInfo().getName());
        log.info("处理器核心数: {}", Runtime.getRuntime().availableProcessors());
        log.info("JVM最大可用内存: {} MB", SystemUtil.getMaxMemory() / 1024 / 1024);
        log.info("JVM当前全部内存: {} MB", SystemUtil.getTotalMemory() / 1024 / 1024);
        log.info("JVM当前剩余内存: {} MB", SystemUtil.getFreeMemory() / 1024 / 1024);
        log.info("==================");
        log.info("");

        String port = SpringUtil.getProperty("local.server.port");
        String ipAddress = SystemUtil.getHostInfo().getAddress();
        if (CharSequenceUtil.isNotBlank(port)) {
            //noinspection HttpUrlsUsage
            log.info("服务访问地址: http://{}:{}", ipAddress, port);
        }
    }
}
