package top.jcsun.breeze.model;

import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import lombok.Data;

import java.io.Serializable;

@Data
@JsonNaming(PropertyNamingStrategies.SnakeCaseStrategy.class)
public class Ipv4Location implements Serializable {
    /**
     * city String 城市
     */
    private String city;

    /**
     * country String 国家
     */
    private String country;

    /**
     * 国家英文简写
     */
    private String countryEnglish;

    /**
     * IP 地址
     */
    private String ip;

    /**
     * isp String 运营商
     */
    private String isp;

    /**
     * latitude String 纬度
     */
    private String latitude;

    /**
     * longitude String 经度
     */
    private String longitude;

    /**
     * province String 省份
     */
    private String province;
}