package top.jcsun.breeze.util;

import cn.hutool.core.net.Ipv4Util;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.http.HttpUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import lombok.experimental.UtilityClass;
import top.jcsun.breeze.model.Ipv4Location;

@UtilityClass
public class IpQueryUtil {
    /**
     * 获取 IP 信息
     *
     * @param ip IP 地址
     * @return {@link Ipv4Location }
     */
    public Ipv4Location getIpInfo(String ip) {
        String url = String.format("https://api.ipdatacloud.com/v2/query?ip=%s&key=d984d86ba25a11ef973200163e167ffb", ip);
        String json = HttpUtil.get(url);
        JSONObject jsonObject = JSONUtil.parseObj(json);
        JSONObject data = jsonObject.getJSONObject("data");
        return data.getBean("location", Ipv4Location.class);
    }

    /**
     * <p>随机公网 IP</p>
     *
     * @return {@link String }
     */
    public String generateRandomPublicIP() {
        String ip;
        do {
            ip = RandomUtil.randomInt(1, 255) + "." + RandomUtil.randomInt(1, 255) + "." + RandomUtil.randomInt(1, 255) + "." + RandomUtil.randomInt(1, 255);
            // 如果是私有IP，继续生成
        } while (Ipv4Util.isInnerIP(ip));
        return ip;
    }
}


