/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support;

import com.ibiz.excel.picture.support.annotation.AutoFile;
import com.ibiz.excel.picture.support.annotation.AutoWrite;
import com.ibiz.excel.picture.support.annotation.InjectSheet;
import com.ibiz.excel.picture.support.event.WorkbookEvent;
import com.ibiz.excel.picture.support.factory.RepositoryFactory;
import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.model.Sheet;
import com.ibiz.excel.picture.support.module.RelationShip;
import com.ibiz.excel.picture.support.util.ClassScanUtil;
import com.ibiz.excel.picture.support.util.CovertUtil;
import com.ibiz.excel.picture.support.util.FileUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SheetContext {
    private final Sheet sheet;
    private final String BASE_PACKAGE = "com.ibiz.excel.picture.support.module";
    private ConcurrentMap<String, IRepository> repositoryHolder = new ConcurrentHashMap<String, IRepository>();
    private List<WorkbookEvent> events = new ArrayList<WorkbookEvent>();

    private SheetContext(Sheet sheet) {
        this.sheet = sheet;
    }

    public ConcurrentMap<String, IRepository> getRepositoryHolder() {
        return this.repositoryHolder;
    }

    public static SheetContext getInstance(Sheet sheet) {
        SheetContext context = new SheetContext(sheet);
        context.init();
        return context;
    }

    public List<WorkbookEvent> getEvents() {
        return this.events;
    }

    private void init() {
        List<Class> classes = ClassScanUtil.scan("com.ibiz.excel.picture.support.module", AutoWrite.class);
        classes.stream().sorted(Comparator.comparing(c -> c.getAnnotation(AutoWrite.class).sort())).forEach(c -> {
            try {
                this.initRepository((Class<?>)c);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    private void initRepository(Class<?> clazz) throws IllegalAccessException, InstantiationException {
        AutoWrite annotation = clazz.getAnnotation(AutoWrite.class);
        String dir = annotation.dir();
        File parentFile = FileUtil.createDir(this.sheet.getWorkbook().getWorkbookFile(), dir);
        Object obj = clazz.newInstance();
        Field[] fields = clazz.getDeclaredFields();
        if (null != fields) {
            Arrays.asList(fields).stream().filter(f -> null != f.getAnnotation(InjectSheet.class)).forEach(f -> {
                f.setAccessible(true);
                try {
                    f.set(obj, this.sheet);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
            Arrays.asList(fields).stream().filter(f -> null != f.getAnnotation(AutoFile.class)).forEach(f -> {
                f.setAccessible(true);
                AutoFile autoFile = f.getAnnotation(AutoFile.class);
                String alias = autoFile.alias();
                File finalFile = this.createFile(parentFile, autoFile);
                try {
                    this.repositoryHolder.put(alias, this.createRepository(alias, f.get(obj), finalFile, autoFile.xmlEnd(), autoFile.writeXmlHead()));
                }
                catch (IOException | IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        Method[] declaredMethods = clazz.getDeclaredMethods();
        Arrays.asList(declaredMethods).stream().filter(m -> null != m.getAnnotation(AutoFile.class)).forEach(m -> {
            m.setAccessible(true);
            AutoFile autoFile = m.getAnnotation(AutoFile.class);
            String alias = autoFile.alias();
            File finalFile = this.createFile(parentFile, autoFile);
            try {
                this.repositoryHolder.put(alias, this.createRepository(alias, m.invoke(obj, new Object[0]), finalFile, autoFile.xmlEnd(), autoFile.writeXmlHead()));
            }
            catch (IOException | IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private File createFile(File parentFile, AutoFile autoFile) {
        String subDir = autoFile.subDir();
        String fileName = autoFile.fileName();
        File finalFile = parentFile;
        if (null != subDir) {
            finalFile = FileUtil.createDir(parentFile, subDir);
        }
        if (null != fileName) {
            finalFile = FileUtil.createFile(finalFile, fileName);
        }
        return finalFile;
    }

    private IRepository createRepository(String alias, Object content, File finalFile, String xmlEnd, boolean writeXmlHead) throws IOException {
        String ct = "";
        if (content instanceof String) {
            ct = (String)content;
        } else if (content instanceof ArrayList) {
            ct = this.covert((ArrayList)content);
        }
        IRepository repository = RepositoryFactory.getNewInstance(alias, finalFile, ct, xmlEnd, writeXmlHead);
        return repository;
    }

    private String covert(List list) {
        StringBuffer content = new StringBuffer();
        if (null != list) {
            Object o = list.get(0);
            boolean covert = false;
            if (o instanceof RelationShip) {
                covert = true;
            }
            if (covert) {
                content.append("<Relationships xmlns=\"http://schemas.openxmlformats.org/package/2006/relationships\">");
                list.stream().forEach(t -> content.append(CovertUtil.covert((RelationShip)t)));
            }
        }
        return content.toString();
    }
}

