/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.factory;

import com.ibiz.excel.picture.support.flush.Drawing1Handler;
import com.ibiz.excel.picture.support.flush.DrawingXmlRelsHandler;
import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.flush.Repository;
import com.ibiz.excel.picture.support.flush.SharedStringXmlHandler;
import com.ibiz.excel.picture.support.flush.Sheet1Handler;
import com.ibiz.excel.picture.support.flush.StylesHandler;
import com.ibiz.excel.picture.support.util.StringUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;

public class RepositoryFactory {
    public static IRepository getNewInstance(String alisa, File file, String content, String endContent, boolean writeXmlHead) throws IOException {
        Repository instance = new Repository();
        String name = file.getName();
        if (name.indexOf(".") > -1) {
            instance.setWrite(new BufferedWriter(new FileWriter(file)));
        }
        instance.setFile(file);
        instance.setWriteXmlHead(writeXmlHead);
        instance.append(content);
        instance.setEndContent(endContent);
        IRepository repository = instance;
        if (StringUtils.equals(alisa, "drawing1_xml_rels")) {
            repository = (IRepository)Proxy.newProxyInstance(RepositoryFactory.class.getClassLoader(), new Class[]{IRepository.class}, (InvocationHandler)new DrawingXmlRelsHandler(instance));
        } else if (StringUtils.equals(alisa, "drawing1")) {
            repository = (IRepository)Proxy.newProxyInstance(RepositoryFactory.class.getClassLoader(), new Class[]{IRepository.class}, (InvocationHandler)new Drawing1Handler(instance));
        } else if (StringUtils.equals(alisa, "shared_string_xml")) {
            repository = (IRepository)Proxy.newProxyInstance(RepositoryFactory.class.getClassLoader(), new Class[]{IRepository.class}, (InvocationHandler)new SharedStringXmlHandler(instance));
        } else if (StringUtils.equals(alisa, "sheet1")) {
            repository = (IRepository)Proxy.newProxyInstance(RepositoryFactory.class.getClassLoader(), new Class[]{IRepository.class}, (InvocationHandler)new Sheet1Handler(instance));
        } else if (StringUtils.equals(alisa, "styles")) {
            repository = (IRepository)Proxy.newProxyInstance(RepositoryFactory.class.getClassLoader(), new Class[]{IRepository.class}, (InvocationHandler)new StylesHandler(instance));
        }
        return repository;
    }
}

