/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.flush;

import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.model.Picture;
import com.ibiz.excel.picture.support.model.Sheet;
import com.ibiz.excel.picture.support.module.RelationShip;
import com.ibiz.excel.picture.support.util.CovertUtil;
import com.ibiz.excel.picture.support.util.FileUtil;
import com.ibiz.excel.picture.support.util.MD5Digester;
import com.ibiz.excel.picture.support.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DrawingXmlRelsHandler
implements InvocationHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private IRepository target;

    public DrawingXmlRelsHandler(IRepository proxy) {
        this.target = proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().equals("write")) {
            Sheet sheet = (Sheet)args[0];
            List<Picture> pictures = sheet.getPictures();
            pictures.stream().filter(Objects::nonNull).forEach(p -> {
                File file;
                if (StringUtils.isNotBlank(p.getPicturePath()) && (file = new File(p.getPicturePath())).exists()) {
                    this.copyPictureAppendDrawingRelsXML(sheet, (Picture)p);
                }
            });
        }
        return method.invoke((Object)this.target, args);
    }

    private void copyPictureAppendDrawingRelsXML(Sheet sheet, Picture picture) {
        try {
            File srcPicture = new File(picture.getPicturePath());
            String md5 = MD5Digester.digestMD5(srcPicture);
            Integer drawingSequence = sheet.getWorkbook().getImageCache().get(md5);
            if (Objects.nonNull(drawingSequence)) {
                picture.setRembed(drawingSequence);
                return;
            }
            File media = ((IRepository)sheet.getSheetContext().getRepositoryHolder().get("media")).getFile();
            drawingSequence = sheet.getDrawingSequence();
            File destPicture = new File(media, "image" + drawingSequence + ".png");
            FileUtil.copyFile(srcPicture, destPicture);
            picture.setRembed(drawingSequence);
            RelationShip relationShip = new RelationShip("rId" + drawingSequence, "http://schemas.openxmlformats.org/officeDocument/2006/relationships/image", "../media/image" + drawingSequence + ".png");
            sheet.getWorkbook().getImageCache().put(md5, drawingSequence);
            Integer n = drawingSequence;
            Integer n2 = drawingSequence = Integer.valueOf(drawingSequence + 1);
            sheet.setDrawingSequence(drawingSequence);
            this.target.append(CovertUtil.covert(relationShip));
        }
        catch (IOException e) {
            this.logger.error("\u56fe\u7247copy\u5230media\u76ee\u5f55\u4e0b\u5f02\u5e38", (Throwable)e);
        }
        catch (Exception e) {
            this.logger.error("\u56fe\u7247copy\u5230media\u76ee\u5f55\u4e0b\u5f02\u5e38", (Throwable)e);
        }
    }
}

