/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.flush;

import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.model.Sheet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;

public class Repository
implements IRepository {
    private boolean hasWriteXmlHead = false;
    private BufferedWriter write;
    private StringBuffer content = new StringBuffer();
    private String endContent;
    private File file;
    private boolean writeXmlHead;

    private void clearContent() {
        this.content.setLength(0);
    }

    @Override
    public void write(Sheet sheet) {
        try {
            if (null == this.write) {
                return;
            }
            this.writeToStream();
        }
        catch (Exception e) {
            throw new RuntimeException("write file error :" + this.file.getAbsolutePath(), e);
        }
    }

    private void writeToStream() {
        try {
            if (!this.hasWriteXmlHead && this.writeXmlHead) {
                this.write.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
                this.hasWriteXmlHead = true;
            }
            this.write.write(this.content.toString());
            this.clearContent();
        }
        catch (IOException e) {
            throw new RuntimeException("write file error :" + this.file.getAbsolutePath(), e);
        }
    }

    @Override
    public void append(String content) {
        this.content.append(content);
    }

    @Override
    public void close(Sheet sheet) {
        block5: {
            if (null == this.write) {
                return;
            }
            try {
                this.writeToStream();
                this.write.write(null == this.endContent ? "" : this.endContent);
                this.write.flush();
                this.write.close();
            }
            catch (IOException e) {
                if (null == this.write) break block5;
                try {
                    this.write.close();
                }
                catch (IOException ex) {
                    throw new RuntimeException("close write buff error", ex);
                }
            }
        }
    }

    @Override
    public File getFile() {
        return this.file;
    }

    public StringBuffer getContent() {
        return this.content;
    }

    public void setContent(StringBuffer content) {
        this.content = content;
    }

    public void setWrite(BufferedWriter write) {
        this.write = write;
    }

    public void setEndContent(String endContent) {
        this.endContent = endContent;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setWriteXmlHead(boolean writeXmlHead) {
        this.writeXmlHead = writeXmlHead;
    }
}

