/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.flush;

import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.model.Cell;
import com.ibiz.excel.picture.support.model.Row;
import com.ibiz.excel.picture.support.model.Sheet;
import com.ibiz.excel.picture.support.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.List;

public class SharedStringXmlHandler
implements InvocationHandler {
    private IRepository target;

    public SharedStringXmlHandler(IRepository proxy) {
        this.target = proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Sheet sheet;
        List<Row> rows;
        if (method.getName().equals("write") && !(rows = (sheet = (Sheet)args[0]).getRows()).isEmpty()) {
            int subIndex = !sheet.hasFlush() ? 0 : 1;
            rows.subList(subIndex, rows.size()).stream().flatMap(r -> r.getCells().stream()).forEach(c -> this.writeSharedStringXML(sheet, (Cell)c));
        }
        return method.invoke((Object)this.target, args);
    }

    private void writeSharedStringXML(Sheet sheet, Cell cell) {
        StringBuffer sb = new StringBuffer();
        String cellValue = StringUtils.isBlank(cell.getValue()) ? "" : cell.getValue();
        sb.append("<si><t><![CDATA[").append(cellValue).append("]]></t></si>");
        this.target.append(sb.toString());
        sheet.setSharedStringSequence(sheet.getSharedStringSequence() + 1);
        cell.setColDataNumber(sheet.getSharedStringSequence());
    }
}

