/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.flush;

import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.model.Cell;
import com.ibiz.excel.picture.support.model.CellStyle;
import com.ibiz.excel.picture.support.model.ColumnHelper;
import com.ibiz.excel.picture.support.model.MergeCell;
import com.ibiz.excel.picture.support.model.Row;
import com.ibiz.excel.picture.support.model.Sheet;
import com.ibiz.excel.picture.support.util.StringUtils;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.springframework.util.CollectionUtils;

public class Sheet1Handler
implements InvocationHandler {
    private IRepository target;

    public Sheet1Handler(IRepository proxy) {
        this.target = proxy;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Sheet sheet = (Sheet)args[0];
        if (method.getName().equals("write")) {
            List<Row> rows = sheet.getRows();
            if (!rows.isEmpty()) {
                int subIndex = !sheet.hasFlush() ? 0 : 1;
                this.setMergeCell(sheet, rows);
                this.setColumnWidth(sheet, subIndex);
                rows.subList(subIndex, rows.size()).stream().forEach(r -> this.writeSheetXML((Row)r));
            }
        } else if (method.getName().equals("close")) {
            this.setEndSheetData();
            this.setMergeContent(sheet);
        }
        return method.invoke((Object)this.target, args);
    }

    private void setColumnWidth(Sheet sheet, int subIndex) {
        if (subIndex == 0) {
            StringBuilder content = new StringBuilder();
            content.append("<cols>").append("<col min=\"1\" max=\"4\" width=\"23.5\"/>");
            sheet.getColumnHelperMap().entrySet().forEach(column -> content.append("<col min=\"").append(column.getKey()).append("\" max=\"").append(column.getKey()).append("\" width=\"").append(((ColumnHelper)column.getValue()).getWidth()).append("\" customWidth=\"1\"/>"));
            content.append("</cols><sheetData>");
            this.target.append(content.toString());
        }
    }

    private void setMergeContent(Sheet sheet) {
        Set<String> colCells = sheet.getColCells();
        StringBuilder content = new StringBuilder();
        if (sheet.isAutoMergeCell() && !sheet.getMergeCells().isEmpty()) {
            content.append("<mergeCells count=\"").append(sheet.getMergeCells().size()).append("\">");
            sheet.getMergeCells().stream().forEach(m -> {
                if (CollectionUtils.isEmpty((Collection)colCells)) {
                    Cell start = new Cell(m.getFirstRow(), m.getFirstCol());
                    Cell end = new Cell(m.getLastRow(), m.getLastCol());
                    content.append("<mergeCell ref=\"").append(start.getColNumber()).append(":").append(end.getColNumber()).append("\"/>");
                } else {
                    colCells.forEach(c -> content.append("<mergeCell ref=\"").append((String)c).append(m.getFirstRow()).append(":").append((String)c).append(m.getLastRow()).append("\"/>"));
                }
            });
            content.append("</mergeCells>");
        }
        this.target.append(content.toString());
    }

    private void setEndSheetData() {
        this.target.append("</sheetData>");
    }

    private void setMergeCell(Sheet sheet, List<Row> rows) {
        String oldValue = "";
        for (int i = 0; i < rows.size(); ++i) {
            Row row = rows.get(i);
            if (null == row) continue;
            List<Cell> cells = row.getCells();
            int mergeCellNumber = sheet.getMergeCellNumber();
            if (mergeCellNumber >= cells.size()) break;
            Cell cell = cells.get(mergeCellNumber);
            if (StringUtils.isNotBlank(oldValue) && oldValue.equals(cell.getValue())) {
                MergeCell mergeCell = null;
                if (!sheet.getMergeCells().isEmpty()) {
                    mergeCell = sheet.getMergeCells().getLast();
                }
                if (null == mergeCell) {
                    mergeCell = new MergeCell();
                }
                int endRowNumber = mergeCell.getLastRow();
                if (row.getRowNumber() == endRowNumber) {
                    mergeCell.setLastRow(++endRowNumber);
                } else {
                    mergeCell = new MergeCell().setFirstRow(row.getRowNumber()).setLastRow(row.getRowNumber() + 1);
                    sheet.getMergeCells().add(mergeCell);
                }
            }
            oldValue = StringUtils.isBlank(cell.getValue()) ? "" : cell.getValue();
        }
    }

    private void writeSheetXML(Row row) {
        StringBuilder content = new StringBuilder();
        content.append("<row r=\"").append(row.getRowNumber() + 1).append("\" ht=\"").append(row.getHeight()).append("\" customHeight=\"1\"").append(" spans=\"1:").append(row.getCells().size()).append("\">");
        row.getCells().forEach(c -> content.append("<c r=\"").append(c.getColNumber()).append("\" s=\"").append(Optional.ofNullable(row.getCellStyle()).map(CellStyle::getS).orElse(1)).append("\" t=\"s\">").append("<v>").append(c.getColDataNumber()).append("</v></c>"));
        content.append("</row>");
        this.target.append(content.toString());
    }
}

