/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.model;

import com.ibiz.excel.picture.support.model.Cell;
import com.ibiz.excel.picture.support.model.CellStyle;
import java.util.ArrayList;
import java.util.List;

public class Row {
    private int rowNumber;
    private int autoHeight = 30;
    private int height;
    private List<Cell> cells = new ArrayList<Cell>();
    private CellStyle cellStyle;

    public Row() {
        this(1);
    }

    public Row(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public int getHeight() {
        return this.height <= 0 ? this.autoHeight : this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public void setRowNumber(int rowNumber) {
        this.rowNumber = rowNumber;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public void autoRowCells(List<Cell> cells) {
        cells.parallelStream().forEach(cell -> cell.autoSetRowNumber(this.rowNumber));
        this.cells = cells;
    }

    public Cell createCell(int cellNumber) {
        Cell cell = new Cell(this.rowNumber, cellNumber);
        this.cells.add(cell);
        return cell;
    }

    public void clear() {
        this.cells.clear();
    }

    public CellStyle getCellStyle() {
        return this.cellStyle;
    }

    public Row setCellStyle(CellStyle cellStyle) {
        this.cellStyle = new CellStyle(cellStyle);
        return this;
    }
}

