/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.model;

import com.ibiz.excel.picture.support.SheetContext;
import com.ibiz.excel.picture.support.annotation.ExportModel;
import com.ibiz.excel.picture.support.event.CloseEvent;
import com.ibiz.excel.picture.support.event.FlushEvent;
import com.ibiz.excel.picture.support.event.InitEvent;
import com.ibiz.excel.picture.support.factory.EventFactory;
import com.ibiz.excel.picture.support.factory.ListenerFactory;
import com.ibiz.excel.picture.support.flush.IRepository;
import com.ibiz.excel.picture.support.listener.CloseListener;
import com.ibiz.excel.picture.support.listener.ContentListener;
import com.ibiz.excel.picture.support.listener.FlushListener;
import com.ibiz.excel.picture.support.listener.InitListener;
import com.ibiz.excel.picture.support.model.Cell;
import com.ibiz.excel.picture.support.model.ColumnHelper;
import com.ibiz.excel.picture.support.model.MergeCell;
import com.ibiz.excel.picture.support.model.Picture;
import com.ibiz.excel.picture.support.model.Row;
import com.ibiz.excel.picture.support.model.Workbook;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Sheet {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private SheetContext sheetContext;
    private int flushSize;
    private Workbook workbook;
    private String sheetName;
    private int drawingSequence = 1;
    private int sharedStringSequence = -1;
    private boolean autoMergeCell = Boolean.TRUE;
    private boolean hasFlush;
    private boolean hasWriteHead;
    private final List<String> closeAlias = Arrays.asList("app", "workbook_xml");
    private final SheetHandler SHEET_HANDLER = new SheetHandler();
    private int writeRow = -1;
    private List<Row> rows = new ArrayList<Row>();
    private List<Picture> pictures = new ArrayList<Picture>();
    private LinkedList<MergeCell> mergeCells = new LinkedList();
    private int mergeCellNumber = 0;
    private Set<String> colCells = new HashSet<String>();
    private Map<Integer, ColumnHelper> columnHelperMap = new HashMap<Integer, ColumnHelper>();
    private int fillId = 33;
    private int s = 4;

    private void init() {
        this.SHEET_HANDLER.init();
    }

    private Sheet(int flushSize, String sheetName, Workbook workbook) {
        this.flushSize = flushSize;
        this.sheetName = sheetName;
        this.workbook = workbook;
        this.init();
    }

    public int getFillId() {
        return this.fillId;
    }

    public void setFillId(int fillId) {
        this.fillId = fillId;
    }

    public int getS() {
        return this.s;
    }

    public void setS(int s) {
        this.s = s;
    }

    public List<Picture> getPictures() {
        return this.pictures;
    }

    public Workbook getWorkbook() {
        return this.workbook;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public <T> Row createRow(T t) {
        return this.SHEET_HANDLER.createRow(t);
    }

    public Row createRow(int rowNumber) {
        return this.SHEET_HANDLER.createRow(rowNumber);
    }

    public void flush() {
        this.sheetContext.getEvents().stream().filter(e -> e instanceof FlushEvent).forEach(e -> e.onEvent(this));
        this.hasFlush = true;
        this.clear();
    }

    public boolean hasFlush() {
        return this.hasFlush;
    }

    public void close() {
        this.flush();
        this.sheetContext.getEvents().stream().filter(e -> e instanceof CloseEvent).forEach(e -> e.onEvent(this));
    }

    public void clear() {
        this.SHEET_HANDLER.clear();
    }

    public SheetContext getSheetContext() {
        return this.sheetContext;
    }

    public static Sheet getInstance(int flushSize, Workbook workbook) {
        return new Sheet(flushSize, "sheet1", workbook);
    }

    public static Sheet getInstance(int flushSize, String sheetName, Workbook workbook) {
        return new Sheet(flushSize, sheetName, workbook);
    }

    public boolean isAutoMergeCell() {
        return this.autoMergeCell;
    }

    public void setAutoMergeCell(boolean autoMergeCell) {
        this.autoMergeCell = autoMergeCell;
    }

    public LinkedList<MergeCell> getMergeCells() {
        return this.mergeCells;
    }

    public int getMergeCellNumber() {
        return this.mergeCellNumber;
    }

    public void setMergeCellNumber(int mergeCellNumber) {
        this.mergeCellNumber = mergeCellNumber;
    }

    public int getSharedStringSequence() {
        return this.sharedStringSequence;
    }

    public void setSharedStringSequence(int sharedStringSequence) {
        this.sharedStringSequence = sharedStringSequence;
    }

    public Set<String> getColCells() {
        return this.colCells;
    }

    public void setColCells(Set<String> colCells) {
        this.colCells = colCells;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public Row getRow(int num) {
        return this.getRows().get(num);
    }

    public int getDrawingSequence() {
        return this.drawingSequence;
    }

    public void setDrawingSequence(int drawingSequence) {
        this.drawingSequence = drawingSequence;
    }

    public int getRowCount() {
        return this.writeRow + 1;
    }

    public int getFlushSize() {
        return this.flushSize;
    }

    public Sheet setColumnWidth(int columnIndex, double width) {
        if (!this.columnHelperMap.containsKey(columnIndex)) {
            this.columnHelperMap.put(columnIndex, new ColumnHelper(columnIndex, width));
        } else {
            ColumnHelper columnHelper = this.columnHelperMap.get(columnIndex);
            if (width > columnHelper.getWidth()) {
                columnHelper.setWidth(width);
            }
        }
        return this;
    }

    public Map<Integer, ColumnHelper> getColumnHelperMap() {
        return this.columnHelperMap;
    }

    class SheetHandler {
        SheetHandler() {
        }

        void init() {
            Sheet.this.sheetContext = SheetContext.getInstance(Sheet.this);
            ContentListener init = ListenerFactory.getInstance(InitListener.class);
            ContentListener flush = ListenerFactory.getInstance(FlushListener.class);
            ContentListener close = ListenerFactory.getInstance(CloseListener.class);
            Sheet.this.sheetContext.getRepositoryHolder().forEach((alias, rep) -> {
                if (!Sheet.this.closeAlias.contains(alias)) {
                    init.addRepository((IRepository)rep);
                    flush.addRepository((IRepository)rep);
                }
                close.addRepository((IRepository)rep);
            });
            Sheet.this.sheetContext.getEvents().add(EventFactory.getInstance(InitEvent.class).registry(init));
            Sheet.this.sheetContext.getEvents().add(EventFactory.getInstance(FlushEvent.class).registry(flush));
            Sheet.this.sheetContext.getEvents().add(EventFactory.getInstance(CloseEvent.class).registry(close));
            Sheet.this.sheetContext.getEvents().stream().filter(e -> e instanceof InitEvent).forEach(e -> e.onEvent(Sheet.this));
        }

        <T> Row create(T t, boolean isHead) {
            Row row = this.createRow(++Sheet.this.writeRow);
            Sheet.this.logger.info("create the " + Sheet.this.writeRow + " row");
            Arrays.stream(t.getClass().getDeclaredFields()).filter(f -> null != f.getAnnotation(ExportModel.class)).sorted(Comparator.comparing(c -> c.getAnnotation(ExportModel.class).sort())).forEach(f -> {
                f.setAccessible(true);
                ExportModel model = f.getAnnotation(ExportModel.class);
                int sort = model.sort();
                boolean isPicture = model.isPicture();
                boolean mergeMaster = model.mergeMaster();
                boolean merge = model.merge();
                int width = model.width();
                int height = model.height();
                String title = model.title();
                Cell cell = new Cell(row.getRowNumber(), sort);
                if (isHead && mergeMaster) {
                    Sheet.this.mergeCellNumber = sort;
                    Sheet.this.autoMergeCell = true;
                    Sheet.this.colCells.add(cell.getCol());
                }
                if (isHead && merge) {
                    Sheet.this.colCells.add(cell.getCol());
                }
                Object value = null;
                try {
                    value = f.get(t);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                if (isHead) {
                    cell.setValue(title);
                } else if (isPicture && value != null) {
                    this.addPictures(row, cell.getCellNumber(), width, height, value);
                } else {
                    cell.setValue(value == null ? "" : String.valueOf(value));
                }
                row.getCells().add(cell);
            });
            Sheet.this.hasWriteHead = Sheet.this.writeRow > -1;
            return row;
        }

        private void addPictures(Row row, int cellNumber, int width, int height, Object value) {
            List values = new ArrayList<String>();
            row.setHeight(height / 12600 - 1);
            if (value instanceof List) {
                values = (List)value;
            } else {
                values.add(String.valueOf(value));
            }
            int actualWidth = width / 76923;
            int valuesSize = values.size();
            valuesSize = valuesSize == 0 ? 1 : valuesSize;
            double columnWidth = (double)(actualWidth * valuesSize) + (double)valuesSize / 1.5;
            Sheet.this.setColumnWidth(cellNumber + 1, columnWidth);
            values.forEach(v -> Sheet.this.pictures.add(new Picture(row.getRowNumber(), cellNumber, width, height, (String)v)));
        }

        <T> Row createRow(T t) {
            if (!Sheet.this.hasWriteHead) {
                this.create(t, true);
            }
            return this.create(t, false);
        }

        Row createRow(int rowNumber) {
            Sheet.this.writeRow = rowNumber;
            if (Sheet.this.rows.size() > Sheet.this.flushSize && Sheet.this.flushSize != -1) {
                Sheet.this.flush();
            }
            Row row = new Row(rowNumber);
            Sheet.this.rows.add(row);
            return row;
        }

        void clear() {
            Row row = null;
            if (Sheet.this.rows.size() > 1) {
                row = (Row)Sheet.this.rows.get(Sheet.this.rows.size() - 1);
            }
            ArrayList<Row> list = new ArrayList<Row>();
            list.add(row);
            Sheet.this.rows.clear();
            Sheet.this.rows.addAll(list);
            Sheet.this.pictures.clear();
        }
    }
}

