/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.model;

import cn.hutool.core.util.ZipUtil;
import com.ibiz.excel.picture.support.constants.WorkbookConstant;
import com.ibiz.excel.picture.support.model.CellStyle;
import com.ibiz.excel.picture.support.model.Sheet;
import com.ibiz.excel.picture.support.util.FileUtil;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Workbook {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private int flushSize;
    private List<Sheet> sheets;
    private final File workbookFile;
    private final String filePath;
    private final String destPath;
    private File destFile;
    private boolean close;
    private Map<String, Integer> imageCache = new HashMap<String, Integer>();
    private CellStyle cellStyle;

    public File getWorkbookFile() {
        return this.workbookFile;
    }

    public Map<String, Integer> getImageCache() {
        return this.imageCache;
    }

    private Workbook() {
        this(100);
    }

    private Workbook(int flushSize) {
        this.flushSize = flushSize;
        this.filePath = WorkbookConstant.AUTO_DIR + "/" + UUID.randomUUID().toString().replace("-", "");
        this.destPath = WorkbookConstant.AUTO_DIR + "/" + UUID.randomUUID().toString().replace("-", "") + ".xlsx";
        this.workbookFile = FileUtil.createDir(null, this.filePath);
        this.sheets = new ArrayList<Sheet>();
    }

    public static Workbook getInstance() {
        return Workbook.getInstance(100);
    }

    public static Workbook getInstance(int flushSize) {
        return new Workbook(flushSize);
    }

    public Sheet createSheet() {
        Sheet sheet = Sheet.getInstance(this.flushSize, this);
        this.sheets.add(sheet);
        return sheet;
    }

    public Sheet createSheet(String sheetName) {
        Sheet sheet = Sheet.getInstance(this.flushSize, sheetName, this);
        this.sheets.add(sheet);
        return sheet;
    }

    private void write() {
        if (this.sheets.isEmpty()) {
            throw new RuntimeException("none sheet has create");
        }
        this.sheets.forEach(Sheet::close);
        ZipUtil.zip((String)this.filePath, (String)this.destPath);
        this.destFile = new File(this.destPath);
        this.deleteFile(this.filePath);
        this.logger.info("dest excel path:{}", (Object)this.destPath);
    }

    public void close() {
        if (!this.close) {
            this.deleteFile(this.destPath);
            this.logger.info("delete dest excel path:{}", (Object)this.destPath);
        }
        this.close = true;
    }

    public void write(OutputStream output) {
        this.checkClose();
        this.write();
        FileUtil.writeToOutput(this.destFile, output);
    }

    private void deleteFile(String path) {
        File file = new File(path);
        FileUtil.delete(file);
    }

    private void checkClose() {
        if (this.close) {
            throw new RuntimeException("workbook is closed");
        }
    }

    public CellStyle createCellStyle() {
        CellStyle cellStyle;
        this.cellStyle = cellStyle = new CellStyle();
        return cellStyle;
    }
}

