/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MD5Digester {
    public static final char[] DIGITAL = "0123456789ABCDEF".toCharArray();

    private MD5Digester() {
    }

    public static String digestMD5(File file) throws FileNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        return MD5Digester.digestMD5(fis);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String digestMD5(InputStream inputStream) {
        try (InputStream is = inputStream;){
            int len;
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] buffer = new byte[8192];
            while (-1 != (len = is.read(buffer))) {
                digest.update(buffer, 0, len);
            }
            byte[] md5hash = digest.digest();
            String string = MD5Digester.encodeHexStr(md5hash);
            return string;
        }
        catch (IOException | NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    private static String encodeHexStr(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        char[] result = new char[bytes.length * 2];
        for (int i = 0; i < bytes.length; ++i) {
            result[i * 2] = DIGITAL[(bytes[i] & 0xF0) >> 4];
            result[i * 2 + 1] = DIGITAL[bytes[i] & 0xF];
        }
        return new String(result);
    }
}

