/*
 * Decompiled with CFR 0.152.
 */
package com.ibiz.excel.picture.support.util;

import cn.hutool.core.io.FileUtil;
import com.ibiz.excel.picture.support.model.Workbook;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.util.WebUtils;

public class WebUtil {
    private static final Logger log = LoggerFactory.getLogger(WebUtils.class);

    public static void writeExcelTest(Workbook wb, String fileName, String tempPath) {
        File file = FileUtil.touch((String)tempPath.concat(fileName));
        try (BufferedOutputStream os = FileUtil.getOutputStream((File)file);){
            wb.write(os);
            wb.close();
        }
        catch (Exception e) {
            FileUtil.del((File)file);
            log.error("\u6d4b\u8bd5\u5bfc\u51faexcel\u5f02\u5e38", (Throwable)e);
        }
        log.debug("\u6d4b\u8bd5\u5bfc\u51faexcel\u8def\u5f84\uff1a{}", (Object)file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeExcel(Workbook wb, String fileName, HttpServletResponse response) throws IOException {
        response.reset();
        response.setHeader("Content-Disposition", "attachment; filename=" + URLEncoder.encode(fileName, "UTF-8"));
        response.setContentType("application/octet-stream");
        try (ServletOutputStream os = response.getOutputStream();){
            wb.write((OutputStream)os);
        }
        catch (Exception e) {
            log.error("\u5bfc\u51faexcel\u5f02\u5e38", (Throwable)e);
        }
        finally {
            wb.close();
        }
    }
}

