/*
 * Decompiled with CFR 0.152.
 */
package top.populus.bees.main.manager;

import cn.hutool.setting.Setting;
import com.google.common.collect.Iterables;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import top.populus.bees.able.ResourceAble;
import top.populus.bees.able.impl.AbstractResourceAble;
import top.populus.bees.core.config.base.BeesConfig;
import top.populus.bees.core.server.base.Iserver;
import top.populus.bees.main.manager.BeesManager;
import top.populus.bees.utils.CommonUtil;

@Component
public class BeesManagerImpl
implements BeesManager {
    private static Logger log = LoggerFactory.getLogger(BeesManagerImpl.class);
    private ExecutorService ex;
    @Autowired
    private AbstractResourceAble resourceAble;
    private BeesConfig config;
    private ServiceLoader<Iserver> iservers;

    @Override
    public void start() {
        this.init();
        this.run();
    }

    @Override
    public void shutdown() {
        try {
            log.info("\u63a5\u6536\u5230\u5173\u95ed\u4fe1\u53f7........................");
            for (Iserver server : this.iservers) {
                server.getConfig().setRunState(false);
            }
            for (Iserver server : this.iservers) {
                server.shutdown();
            }
            this.ex.shutdownNow();
        }
        finally {
            while (!this.ex.isTerminated()) {
                CommonUtil.sleep((long)1000L);
                log.info("\u8fd8\u5728\u7ee7\u7eed......");
            }
            this.resourceAble.closeResources();
        }
    }

    private void run() {
        this.iservers = ServiceLoader.load(Iserver.class);
        int count = Iterables.size(this.iservers);
        log.info("total of  '" + count + "'  service will start.");
        this.ex = Executors.newFixedThreadPool(count);
        for (Iserver server : this.iservers) {
            server.setResourceAble((ResourceAble)this.resourceAble);
            this.ex.execute((Runnable)server);
        }
    }

    private void init() {
        this.config = BeesConfig.buildConifg();
        this.resourceAble.initResourceConfig((Setting)this.config);
    }
}

