/*
 * Decompiled with CFR 0.152.
 */
package top.populus.bees.main.manager;

import cn.hutool.setting.Setting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import top.populus.bees.able.impl.AbstractResourceAble;

@Component
public class ResourceAbleImpl
extends AbstractResourceAble {
    private static Logger log = LoggerFactory.getLogger(AbstractResourceAble.class);

    public void initResourceConfig(Setting config) {
        String prex = "......";
        Setting psSetting = this.getSetting(config, "presto_ds");
        Setting rsSetting = this.getSetting(config, "redis_ds");
        Setting esSetting = this.getSetting(config, "es_ds");
        Setting rqSetting = this.getSetting(config, "roketmq");
        if (psSetting != null && psSetting.getBool((Object)"is_load").booleanValue()) {
            this.getPrestoDs().initDS(psSetting);
            log.info(prex + "presto resource initialized.");
        }
        if (rsSetting != null && rsSetting.getBool((Object)"is_load").booleanValue()) {
            this.getJedisDs().initDS(rsSetting);
            log.info(prex + "redis resource initialized.");
        }
        if (esSetting != null && esSetting.getBool((Object)"is_load").booleanValue()) {
            this.getEsDs().initDS(esSetting);
            log.info(prex + "elastic search  resource initialized.");
        }
        if (rqSetting != null && rqSetting.getBool((Object)"is_load").booleanValue()) {
            this.getRoketmq().initDS(esSetting);
            log.info(prex + "roketMq  resource initialized.");
        }
    }

    private Setting getSetting(Setting config, String type) {
        Setting st = config.getSetting(type);
        return st.size() == 0 ? null : st;
    }

    public void closeResources() {
        this.getPrestoDs().close();
        this.getJedisDs().close();
        this.getEsDs().close();
    }
}

