/*
 * Decompiled with CFR 0.152.
 */
package top.redscorpion.api.oss.local;

import java.io.File;
import java.io.IOException;
import org.springframework.web.multipart.MultipartFile;
import top.redscorpion.api.oss.core.OssLocalParam;
import top.redscorpion.api.oss.core.OssSetting;
import top.redscorpion.core.date.DateTime;
import top.redscorpion.core.exception.RsException;
import top.redscorpion.core.util.RsDate;
import top.redscorpion.core.util.RsFile;
import top.redscorpion.core.util.RsString;

public class LocalOssUtil {
    public static String upload(OssSetting os, String key, MultipartFile file, OssLocalParam par) {
        File f;
        DateTime date = RsDate.date();
        String path = os.getFilePath();
        path = RsString.isBlank((CharSequence)par.getDirectory()) ? path + "/" + date.year() + "/" + date.monthBaseOne() + "/" + date.dayOfMonth() : path + "/" + par.getDirectory();
        File dir = new File(path);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((f = new File(path + "/" + key)).exists()) {
            if (par.getReplace()) {
                f.delete();
            } else {
                throw new RsException("\u6587\u4ef6\u540d\u5df2\u5b58\u5728");
            }
        }
        try {
            file.transferTo(f);
            return path + "/" + key;
        }
        catch (IOException e) {
            throw new RsException("\u4e0a\u4f20\u6587\u4ef6\u51fa\u9519");
        }
    }

    public static String rename(String url, String toKey) {
        File old = new File(url);
        RsFile.rename((File)old, (String)toKey, (boolean)false, (boolean)true);
        return old.getParentFile() + "/" + toKey;
    }

    public static String copy(String url, String toKey) {
        File file = new File(url);
        String newUrl = file.getParentFile() + "/" + toKey;
        RsFile.copy((File)file, (File)new File(newUrl), (boolean)true);
        return newUrl;
    }

    public static void delete(String url) {
        RsFile.del((File)new File(url));
    }
}

