/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.sql.configuration;

import com.efficient.logs.sql.configuration.ActualSqlProperties;
import com.efficient.logs.sql.interceptor.ActualSqlInterceptor;
import java.util.List;
import java.util.Properties;
import javax.annotation.PostConstruct;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={ActualSqlProperties.class})
@ConditionalOnClass(value={SqlSessionFactory.class})
@Configuration
@Lazy(value=false)
@Order
@ConditionalOnProperty(name={"com.efficient.logs.sql.showSql"}, havingValue="true")
public class ActualSqlConfiguration {
    @Autowired
    ActualSqlProperties actualSqlProperties;
    @Autowired
    List<SqlSessionFactory> sqlSessionFactoryList;

    @PostConstruct
    public void registerInterceptor() {
        ActualSqlInterceptor interceptor = new ActualSqlInterceptor();
        Properties properties = new Properties();
        properties.put("", this.actualSqlProperties);
        interceptor.setProperties(properties);
        for (SqlSessionFactory sqlSessionFactory : this.sqlSessionFactoryList) {
            org.apache.ibatis.session.Configuration configuration = sqlSessionFactory.getConfiguration();
            if (ActualSqlConfiguration.isInterceptorExists(configuration, interceptor)) continue;
            configuration.addInterceptor((Interceptor)interceptor);
        }
    }

    private static boolean isInterceptorExists(org.apache.ibatis.session.Configuration configuration, Interceptor interceptor) {
        try {
            return configuration.getInterceptors().contains(interceptor);
        }
        catch (Exception e) {
            return false;
        }
    }
}

