/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.logs.sql.interceptor;

import cn.hutool.core.date.format.FastDateFormat;
import cn.hutool.core.lang.Pair;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.efficient.logs.sql.configuration.ActualSqlProperties;
import com.google.common.base.Stopwatch;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.ibatis.cache.CacheKey;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ResultHandler;
import org.apache.ibatis.session.RowBounds;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class}), @Signature(type=Executor.class, method="query", args={MappedStatement.class, Object.class, RowBounds.class, ResultHandler.class, CacheKey.class, BoundSql.class}), @Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class ActualSqlInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(ActualSqlInterceptor.class);
    private static final FastDateFormat NORMAL_DATE_TIME_FORMAT = FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss");
    private static final Pattern ZERO_TIME_PATTERN = Pattern.compile(" 00:00:00");
    private static final Pattern MULTILINE_PATTERN = Pattern.compile("[\\s\n ]+");
    private static final char SQL_DELIMITER = ';';
    private static final char QUESTION_MARK = '?';
    private static final String SINGLE_QUOTE = "'";
    private static final String ESCAPED_SINGLE_QUOTE = "''";
    private static final String SPACE = " ";
    private static final String METHOD_QUERY = "query";
    private static final String METHOD_UPDATE = "update";
    private static final int PARAMETER_COUNT_4 = 4;
    private static final int PARAMETER_COUNT_6 = 6;
    private ActualSqlProperties actualSqlProperties;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object intercept(Invocation invocation) throws SQLException {
        Object[] args = invocation.getArgs();
        MappedStatement mappedStatement = (MappedStatement)args[0];
        Object parameter = args[1];
        Executor executor = (Executor)invocation.getTarget();
        Object result = null;
        BoundSql boundSql = null;
        Stopwatch stopwatch = Stopwatch.createStarted();
        try {
            if (METHOD_QUERY.equals(invocation.getMethod().getName())) {
                RowBounds rowBounds = (RowBounds)args[2];
                ResultHandler resultHandler = (ResultHandler)args[3];
                CacheKey cacheKey = null;
                if (args.length == 4) {
                    boundSql = mappedStatement.getBoundSql(parameter);
                    cacheKey = executor.createCacheKey(mappedStatement, parameter, rowBounds, boundSql);
                } else if (args.length == 6) {
                    cacheKey = (CacheKey)args[4];
                    boundSql = (BoundSql)args[5];
                }
                result = executor.query(mappedStatement, parameter, rowBounds, resultHandler, cacheKey, boundSql);
            } else if (METHOD_UPDATE.equals(invocation.getMethod().getName())) {
                boundSql = mappedStatement.getBoundSql(parameter);
                result = executor.update(mappedStatement, parameter);
            }
            if (boundSql == null) return result;
        }
        catch (Throwable throwable) {
            if (boundSql == null) throw throwable;
            long elapsed = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
            String sql = this.getSql(mappedStatement.getConfiguration(), boundSql);
            this.formatSqlLog(mappedStatement.getSqlCommandType(), mappedStatement.getId(), sql, elapsed, result);
            throw throwable;
        }
        long elapsed = stopwatch.stop().elapsed(TimeUnit.MILLISECONDS);
        String sql = this.getSql(mappedStatement.getConfiguration(), boundSql);
        this.formatSqlLog(mappedStatement.getSqlCommandType(), mappedStatement.getId(), sql, elapsed, result);
        return result;
    }

    public Object plugin(Object target) {
        if (target instanceof Executor) {
            return Plugin.wrap((Object)target, (Interceptor)this);
        }
        return target;
    }

    public void setProperties(Properties properties) {
        if (properties != null) {
            this.actualSqlProperties = (ActualSqlProperties)properties.get("");
        }
    }

    private String getSql(Configuration configuration, BoundSql boundSql) {
        String sql = boundSql.getSql();
        if (StrUtil.isBlank((CharSequence)sql)) {
            return "";
        }
        sql = this.beautifySql(sql);
        Object parameterObject = boundSql.getParameterObject();
        List parameterMappings = boundSql.getParameterMappings();
        if (parameterObject != null && !parameterMappings.isEmpty()) {
            TypeHandlerRegistry typeHandlerRegistry = configuration.getTypeHandlerRegistry();
            if (typeHandlerRegistry.hasTypeHandler(parameterObject.getClass())) {
                sql = (String)this.replacePlaceholder(sql, parameterObject, 0).getKey();
            } else {
                MetaObject metaObject = configuration.newMetaObject(parameterObject);
                int start = 0;
                for (ParameterMapping parameterMapping : parameterMappings) {
                    Pair<String, Integer> pair;
                    Object value;
                    String property = parameterMapping.getProperty();
                    if (metaObject.hasGetter(property)) {
                        value = metaObject.getValue(property);
                        pair = this.replacePlaceholder(sql, value, start);
                        sql = (String)pair.getKey();
                        start = (Integer)pair.getValue();
                        continue;
                    }
                    if (boundSql.hasAdditionalParameter(property)) {
                        value = boundSql.getAdditionalParameter(property);
                        pair = this.replacePlaceholder(sql, value, start);
                        sql = (String)pair.getKey();
                        start = (Integer)pair.getValue();
                        continue;
                    }
                    if (!StrUtil.contains((CharSequence)property, (char)'.')) continue;
                    List segments = StrUtil.split((CharSequence)property, (char)'.');
                    MetaObject minMeta = metaObject;
                    String segment = null;
                    int len = segments.size();
                    for (int i = 0; i < len; ++i) {
                        segment = (String)segments.get(i);
                        if (!minMeta.hasGetter(segment)) {
                            minMeta = null;
                            break;
                        }
                        if (i >= len - 1) continue;
                        minMeta = minMeta.metaObjectForProperty(segment);
                    }
                    if (minMeta == null) continue;
                    Object value2 = minMeta.getValue(segment);
                    Pair<String, Integer> pair2 = this.replacePlaceholder(sql, value2, start);
                    sql = (String)pair2.getKey();
                    start = (Integer)pair2.getValue();
                }
            }
        }
        return sql;
    }

    private void formatSqlLog(SqlCommandType sqlCommandType, String sqlId, String sql, long elapsed, Object result) {
        if (this.actualSqlProperties.isShowMethod()) {
            log.info("Mapper method: {}", (Object)sqlId);
        }
        if (this.actualSqlProperties.isShowSql()) {
            Object endLine = (sql = sql.trim()).length() > 0 && sql.charAt(sql.length() - 1) != ';' ? Character.valueOf(';') : "";
            log.info("SQL: {}{}", (Object)sql, endLine);
        }
        if (this.actualSqlProperties.isShowElapsed()) {
            log.info("Time Elapsed: {} ms", (Object)elapsed);
        }
        if (this.actualSqlProperties.isShowRows()) {
            switch (sqlCommandType) {
                case INSERT: 
                case UPDATE: 
                case DELETE: {
                    log.debug("Effect Count: {}", result);
                    break;
                }
                case SELECT: {
                    int count = result instanceof Collection ? ((Collection)result).size() : 1;
                    log.info("Record Count ===> {}", (Object)count);
                }
            }
        }
    }

    private String beautifySql(String sql) {
        return MULTILINE_PATTERN.matcher(sql).replaceAll(SPACE);
    }

    private Pair<String, Integer> replacePlaceholder(String sql, Object parameterObject, int start) {
        String result;
        if (parameterObject instanceof String || parameterObject instanceof JSONObject || parameterObject instanceof JSONArray) {
            result = SINGLE_QUOTE + StrUtil.replace((CharSequence)String.valueOf(parameterObject), (CharSequence)SINGLE_QUOTE, (CharSequence)ESCAPED_SINGLE_QUOTE) + SINGLE_QUOTE;
        } else if (parameterObject instanceof Date) {
            String str = NORMAL_DATE_TIME_FORMAT.format((Date)parameterObject);
            result = SINGLE_QUOTE + ZERO_TIME_PATTERN.matcher(str).replaceFirst("") + SINGLE_QUOTE;
        } else {
            result = String.valueOf(parameterObject);
        }
        int i = sql.indexOf(63, start);
        if (i < 0) {
            return Pair.of((Object)sql, (Object)start);
        }
        return Pair.of((Object)(sql.substring(0, i) + result + sql.substring(i + 1)), (Object)(i + result.length()));
    }
}

