/*
 * Decompiled with CFR 0.152.
 */
package com.efficient.system.controller;

import com.efficient.common.permission.Permission;
import com.efficient.common.result.Result;
import com.efficient.logs.annotation.Log;
import com.efficient.logs.constant.LogEnum;
import com.efficient.system.api.SysApplicationService;
import com.efficient.system.model.dto.SysApplicationDTO;
import com.efficient.system.model.dto.SysApplicationListDTO;
import com.efficient.system.model.entity.SysApplication;
import com.efficient.system.model.vo.SysApplicationVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import javax.validation.constraints.NotBlank;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sysApplication"})
@Validated
@Api(tags={"\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528"})
@Permission
public class SysApplicationController {
    @Autowired
    private SysApplicationService sysApplicationService;

    @Log(logOpt=LogEnum.SAVE, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @PostMapping(value={"/save"})
    @ApiOperation(value="\u4fdd\u5b58")
    public Result<SysApplication> save(@Validated @RequestBody SysApplicationDTO dto) {
        return this.sysApplicationService.save(dto);
    }

    @Log(logOpt=LogEnum.QUERY, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @GetMapping(value={"/findByAppCode"})
    @ApiOperation(value="\u8be6\u60c5")
    @ApiImplicitParams(value={@ApiImplicitParam(name="appCode", value="\u6570\u636e\u552f\u4e00\u6807\u8bc6", required=true)})
    public Result<SysApplicationVO> findByAppCode(@NotBlank(message="appCode \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="appCode") @NotBlank(message="appCode \u4e0d\u80fd\u4e3a\u7a7a") String appCode) {
        return this.sysApplicationService.findByAppCode(appCode);
    }

    @Log(logOpt=LogEnum.UPDATE, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @PostMapping(value={"/update"})
    @ApiOperation(value="\u4fee\u6539")
    public Result<Boolean> update(@Validated @RequestBody SysApplicationDTO dto) {
        return this.sysApplicationService.update(dto);
    }

    @Log(logOpt=LogEnum.DELETE, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @GetMapping(value={"/delete"})
    @ApiOperation(value="\u5220\u9664")
    @ApiImplicitParams(value={@ApiImplicitParam(name="id", value="\u6570\u636e\u552f\u4e00\u6807\u8bc6", required=true)})
    public Result<Boolean> delete(@NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") @RequestParam(name="id") @NotBlank(message="id \u4e0d\u80fd\u4e3a\u7a7a") String id) {
        return this.sysApplicationService.delete(id);
    }

    @Log(logOpt=LogEnum.PAGE, module="\u7cfb\u7edf\u7b2c\u4e09\u65b9\u5e94\u7528")
    @PostMapping(value={"/list"})
    @ApiOperation(value="\u5217\u8868", response=Result.class)
    public Result list(@Validated @RequestBody SysApplicationListDTO dto) {
        return Result.ok(this.sysApplicationService.list(dto));
    }
}

