/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.database.puls;

import java.beans.Transient;
import java.util.ArrayList;
import java.util.List;

public class Pagination {
    private static final long serialVersionUID = 1L;
    private long total;
    private int size = 10;
    private long pages;
    private int current = 1;
    private boolean searchCount = true;
    private boolean openSort = true;
    private boolean optimizeCountSql = true;
    private List<String> ascs;
    private List<String> descs;
    private boolean isAsc = true;
    private String orderByField;

    public Pagination() {
    }

    public Pagination(int current, int size) {
        this(current, size, true);
    }

    public Pagination(int current, int size, boolean searchCount) {
        this(current, size, searchCount, true);
    }

    public Pagination(int current, int size, boolean searchCount, boolean openSort) {
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
        this.searchCount = searchCount;
        this.openSort = openSort;
    }

    public boolean hasPrevious() {
        return this.current > 1;
    }

    public boolean hasNext() {
        return (long)this.current < this.pages;
    }

    public long getTotal() {
        return this.total;
    }

    public Pagination setTotal(long total) {
        this.total = total;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public Pagination setSize(int size) {
        this.size = size;
        return this;
    }

    public long getPages() {
        if (this.size == 0) {
            return 0L;
        }
        this.pages = this.total / (long)this.size;
        if (this.total % (long)this.size != 0L) {
            ++this.pages;
        }
        return this.pages;
    }

    public int getCurrent() {
        return this.current;
    }

    public Pagination setCurrent(int current) {
        this.current = current;
        return this;
    }

    @Transient
    public boolean isSearchCount() {
        return this.searchCount;
    }

    public Pagination setSearchCount(boolean searchCount) {
        this.searchCount = searchCount;
        return this;
    }

    @Deprecated
    @Transient
    public String getOrderByField() {
        return this.orderByField;
    }

    public Pagination setOrderByField(String orderByField) {
        if ("".equals(orderByField)) {
            this.orderByField = orderByField;
        }
        return this;
    }

    @Transient
    public boolean isOpenSort() {
        return this.openSort;
    }

    public Pagination setOpenSort(boolean openSort) {
        this.openSort = openSort;
        return this;
    }

    @Transient
    public boolean isOptimizeCountSql() {
        return this.optimizeCountSql;
    }

    public void setOptimizeCountSql(boolean optimizeCountSql) {
        this.optimizeCountSql = optimizeCountSql;
    }

    @Transient
    public List<String> getAscs() {
        return this.orders(this.isAsc, this.ascs);
    }

    public Pagination setAscs(List<String> ascs) {
        this.ascs = ascs;
        return this;
    }

    private List<String> orders(boolean condition, List<String> columns) {
        if (condition && "".equals(this.orderByField)) {
            if (columns == null) {
                columns = new ArrayList<String>();
            }
            if (!columns.contains(this.orderByField)) {
                columns.add(this.orderByField);
            }
        }
        return columns;
    }

    @Transient
    public List<String> getDescs() {
        return this.orders(!this.isAsc, this.descs);
    }

    public Pagination setDescs(List<String> descs) {
        this.descs = descs;
        return this;
    }

    @Deprecated
    @Transient
    public boolean isAsc() {
        return this.isAsc;
    }

    public Pagination setAsc(boolean isAsc) {
        this.isAsc = isAsc;
        return this;
    }

    public String toString() {
        return "Pagination { total=" + this.total + " ,size=" + this.size + " ,pages=" + this.pages + " ,current=" + this.current + " }";
    }

    public void setPages(long pages) {
        this.pages = pages;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pagination)) {
            return false;
        }
        Pagination other = (Pagination)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        if (this.getSize() != other.getSize()) {
            return false;
        }
        if (this.getPages() != other.getPages()) {
            return false;
        }
        if (this.getCurrent() != other.getCurrent()) {
            return false;
        }
        if (this.isSearchCount() != other.isSearchCount()) {
            return false;
        }
        if (this.isOpenSort() != other.isOpenSort()) {
            return false;
        }
        if (this.isOptimizeCountSql() != other.isOptimizeCountSql()) {
            return false;
        }
        if (this.isAsc() != other.isAsc()) {
            return false;
        }
        List<String> this$ascs = this.getAscs();
        List<String> other$ascs = other.getAscs();
        if (this$ascs == null ? other$ascs != null : !((Object)this$ascs).equals(other$ascs)) {
            return false;
        }
        List<String> this$descs = this.getDescs();
        List<String> other$descs = other.getDescs();
        if (this$descs == null ? other$descs != null : !((Object)this$descs).equals(other$descs)) {
            return false;
        }
        String this$orderByField = this.getOrderByField();
        String other$orderByField = other.getOrderByField();
        return !(this$orderByField == null ? other$orderByField != null : !this$orderByField.equals(other$orderByField));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pagination;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        result = result * 59 + this.getSize();
        long $pages = this.getPages();
        result = result * 59 + (int)($pages >>> 32 ^ $pages);
        result = result * 59 + this.getCurrent();
        result = result * 59 + (this.isSearchCount() ? 79 : 97);
        result = result * 59 + (this.isOpenSort() ? 79 : 97);
        result = result * 59 + (this.isOptimizeCountSql() ? 79 : 97);
        result = result * 59 + (this.isAsc() ? 79 : 97);
        List<String> $ascs = this.getAscs();
        result = result * 59 + ($ascs == null ? 43 : ((Object)$ascs).hashCode());
        List<String> $descs = this.getDescs();
        result = result * 59 + ($descs == null ? 43 : ((Object)$descs).hashCode());
        String $orderByField = this.getOrderByField();
        result = result * 59 + ($orderByField == null ? 43 : $orderByField.hashCode());
        return result;
    }
}

