/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.service;

import com.wu.framework.easy.excel.service.ExcelExcelService;
import com.wu.framework.easy.excel.stereotype.EasyExcel;
import com.wu.framework.easy.excel.stereotype.EasyExcelBean;
import com.wu.framework.easy.excel.util.ISheetShowContextMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.RichTextString;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

public class ComplexExcelExportService
implements ExcelExcelService {
    public static byte[] exportExcel(EasyExcel easyExcel, Collection collection) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (easyExcel.multipleSheet()) {
            List<List> splitList = ExcelExcelService.splitList(new ArrayList(collection), easyExcel.limit());
            ISheetShowContextMethod iSheetShowContextMethod = easyExcel.sheetShowContext().getISheetShowContextMethod().newInstance();
            List<String> sheetContextList = iSheetShowContextMethod.sheetContext(collection.size(), easyExcel.limit());
            for (int i = 0; i < splitList.size(); ++i) {
                ComplexExcelExportService.complexSingleSheet(workbook, sheetContextList.get(i), easyExcel, splitList.get(i));
            }
        } else {
            ComplexExcelExportService.complexSingleSheet(workbook, easyExcel.fileName(), easyExcel, collection);
        }
        workbook.write((OutputStream)out);
        return out.toByteArray();
    }

    public static void complexSingleSheet(HSSFWorkbook workbook, String sheetName, EasyExcel easyExcel, Collection collection) {
        try {
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                throw new Exception("\u6570\u636e\u9519\u8bef");
            }
            Object ts = iterator.next();
            HSSFSheet sheet = workbook.createSheet(sheetName);
            sheet.setDefaultColumnWidth(20);
            HSSFCellStyle style = workbook.createCellStyle();
            List fieldList = easyExcel.useAnnotation() ? Arrays.stream(ts.getClass().getDeclaredFields()).filter(field -> null != field.getAnnotation(easyExcel.fieldColumnAnnotation()) || null != field.getAnnotation(EasyExcelBean.class)).peek(field -> field.setAccessible(true)).collect(Collectors.toList()) : Arrays.stream(ts.getClass().getDeclaredFields()).peek(field -> field.setAccessible(true)).collect(Collectors.toList());
            HSSFRow row = sheet.createRow(0);
            int additionalHeader = 0;
            for (int i = 0; i < fieldList.size(); ++i) {
                ComplexExcelExportService.createCellHeader(row, style, i, additionalHeader, (Field)fieldList.get(i), easyExcel);
            }
            boolean rowIndex = true;
            int additionalCell = 0;
            Integer rowNum = ComplexExcelExportService.createCell(sheet, sheet.createRow(1), 1, 0, additionalCell, collection, easyExcel);
            System.out.println("\u603b\u884c\u6570:" + rowNum);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createCellHeader(HSSFRow hssfRow, HSSFCellStyle style, int i, int additionalHeader, Field field, EasyExcel easyExcel) {
        if (Collection.class.isAssignableFrom(field.getType())) {
            Type genericType = field.getGenericType();
            if (genericType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)genericType;
                Class paramClass = (Class)parameterizedType.getActualTypeArguments()[0];
                List paramClassFieldList = Arrays.stream(paramClass.getDeclaredFields()).filter(paramClassField -> null != paramClassField.getAnnotation(easyExcel.fieldColumnAnnotation()) || null != paramClassField.getAnnotation(EasyExcelBean.class)).peek(paramClassField -> paramClassField.setAccessible(true)).collect(Collectors.toList());
                for (Field paramClassField2 : paramClassFieldList) {
                    ComplexExcelExportService.createCellHeader(hssfRow, style, i, additionalHeader, paramClassField2, easyExcel);
                    ++additionalHeader;
                }
            }
        } else {
            String headerName;
            HSSFCell hssfCell = hssfRow.createCell(i + additionalHeader);
            hssfCell.setCellStyle(style);
            if (easyExcel.useAnnotation()) {
                Annotation filedAnnotation = field.getAnnotation(easyExcel.fieldColumnAnnotation());
                if (null == filedAnnotation) {
                    return;
                }
                Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)filedAnnotation);
                headerName = String.valueOf(annotationAttributes.getOrDefault(easyExcel.fieldColumnAnnotationAttribute(), field.getName()));
            } else {
                headerName = field.getName();
            }
            HSSFRichTextString text = new HSSFRichTextString(headerName);
            hssfCell.setCellValue((RichTextString)text);
        }
    }

    public static Integer createCell(HSSFSheet sheet, HSSFRow hssfRow, Integer rowStartIndex, int cellStartIndex, int additionalCell, Object fieldVal, EasyExcel easyExcel) {
        if (Collection.class.isAssignableFrom(fieldVal.getClass()) && !ObjectUtils.isEmpty((Object)fieldVal)) {
            Iterator iterator = ((Collection)fieldVal).iterator();
            Object first = iterator.next();
            Integer tempRowStartIndex = ComplexExcelExportService.createCell(sheet, hssfRow, rowStartIndex, cellStartIndex, additionalCell, first, easyExcel);
            while (iterator.hasNext()) {
                Integer n = rowStartIndex;
                Integer n2 = rowStartIndex = Integer.valueOf(rowStartIndex + 1);
                n = tempRowStartIndex;
                n2 = tempRowStartIndex = Integer.valueOf(tempRowStartIndex + 1);
                hssfRow = sheet.createRow(tempRowStartIndex.intValue());
                int tempAdditionalCell = additionalCell;
                int tempCellStartIndex = cellStartIndex;
                Object paramClassFieldVal = iterator.next();
                tempRowStartIndex = ComplexExcelExportService.createCell(sheet, hssfRow, tempRowStartIndex, tempCellStartIndex, tempAdditionalCell, paramClassFieldVal, easyExcel);
            }
            return tempRowStartIndex;
        }
        if (!ComplexExcelExportService.isBaseType(fieldVal)) {
            Class<?> paramClass = fieldVal.getClass();
            List paramClassFieldList = Arrays.stream(paramClass.getDeclaredFields()).filter(paramClassField -> null != paramClassField.getAnnotation(easyExcel.fieldColumnAnnotation()) || null != paramClassField.getAnnotation(EasyExcelBean.class)).peek(paramClassField -> paramClassField.setAccessible(true)).collect(Collectors.toList());
            int tempAdditionalCell = additionalCell;
            int tempCellStartIndex = cellStartIndex;
            Integer tempRowStartIndex = 0;
            for (Field paramClassField2 : paramClassFieldList) {
                tempRowStartIndex = ComplexExcelExportService.createCell(sheet, hssfRow, rowStartIndex, tempCellStartIndex, tempAdditionalCell, paramClassField2.get(fieldVal), easyExcel);
                ++tempCellStartIndex;
            }
            return tempRowStartIndex;
        }
        HSSFCell hssfCell = hssfRow.createCell(cellStartIndex + additionalCell);
        String textValue = String.valueOf(fieldVal);
        hssfCell.setCellValue(textValue);
        return rowStartIndex;
    }

    public static byte[] exportExcelMultipleSheet(EasyExcel easyExcel, List<String> titlist, List<List> dataSet) {
        if (titlist.size() == 0 || !dataSet.iterator().hasNext()) {
            throw new RuntimeException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u5bf9\uff01");
        }
        byte[] bytes = new byte[]{};
        for (int o = 0; o < dataSet.size(); ++o) {
            ComplexExcelExportService.exportExcel(easyExcel, dataSet.get(0));
        }
        return bytes;
    }

    @Deprecated
    public static boolean isBaseType(Object object) {
        Class<?> className = object.getClass();
        String packageName = className.getPackage().getName();
        return className.equals(Integer.class) || className.equals(Byte.class) || className.equals(Long.class) || className.equals(Double.class) || className.equals(Float.class) || className.equals(Character.class) || className.equals(Short.class) || className.equals(Boolean.class) || packageName.startsWith("java");
    }

    public static int xx(int a) {
        if (a > 10) {
            return ComplexExcelExportService.xx(--a);
        }
        if (a < 10) {
            int b = 0;
            while (a < 10) {
                b = ComplexExcelExportService.xx(--a);
            }
            return b;
        }
        System.out.println(a);
        return a;
    }

    public static class CreateCell {
        private HSSFSheet sheet;
        private HSSFRow hssfRow;
        private Integer rowStartIndex;
        private int cellStartIndex;
        private int additionalCell;
        private Object fieldVal;
        private EasyExcel easyExcel;

        public HSSFSheet getSheet() {
            return this.sheet;
        }

        public HSSFRow getHssfRow() {
            return this.hssfRow;
        }

        public Integer getRowStartIndex() {
            return this.rowStartIndex;
        }

        public int getCellStartIndex() {
            return this.cellStartIndex;
        }

        public int getAdditionalCell() {
            return this.additionalCell;
        }

        public Object getFieldVal() {
            return this.fieldVal;
        }

        public EasyExcel getEasyExcel() {
            return this.easyExcel;
        }

        public void setSheet(HSSFSheet sheet) {
            this.sheet = sheet;
        }

        public void setHssfRow(HSSFRow hssfRow) {
            this.hssfRow = hssfRow;
        }

        public void setRowStartIndex(Integer rowStartIndex) {
            this.rowStartIndex = rowStartIndex;
        }

        public void setCellStartIndex(int cellStartIndex) {
            this.cellStartIndex = cellStartIndex;
        }

        public void setAdditionalCell(int additionalCell) {
            this.additionalCell = additionalCell;
        }

        public void setFieldVal(Object fieldVal) {
            this.fieldVal = fieldVal;
        }

        public void setEasyExcel(EasyExcel easyExcel) {
            this.easyExcel = easyExcel;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateCell)) {
                return false;
            }
            CreateCell other = (CreateCell)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getCellStartIndex() != other.getCellStartIndex()) {
                return false;
            }
            if (this.getAdditionalCell() != other.getAdditionalCell()) {
                return false;
            }
            Integer this$rowStartIndex = this.getRowStartIndex();
            Integer other$rowStartIndex = other.getRowStartIndex();
            if (this$rowStartIndex == null ? other$rowStartIndex != null : !((Object)this$rowStartIndex).equals(other$rowStartIndex)) {
                return false;
            }
            HSSFSheet this$sheet = this.getSheet();
            HSSFSheet other$sheet = other.getSheet();
            if (this$sheet == null ? other$sheet != null : !this$sheet.equals(other$sheet)) {
                return false;
            }
            HSSFRow this$hssfRow = this.getHssfRow();
            HSSFRow other$hssfRow = other.getHssfRow();
            if (this$hssfRow == null ? other$hssfRow != null : !this$hssfRow.equals(other$hssfRow)) {
                return false;
            }
            Object this$fieldVal = this.getFieldVal();
            Object other$fieldVal = other.getFieldVal();
            if (this$fieldVal == null ? other$fieldVal != null : !this$fieldVal.equals(other$fieldVal)) {
                return false;
            }
            EasyExcel this$easyExcel = this.getEasyExcel();
            EasyExcel other$easyExcel = other.getEasyExcel();
            return !(this$easyExcel == null ? other$easyExcel != null : !this$easyExcel.equals(other$easyExcel));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateCell;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getCellStartIndex();
            result = result * 59 + this.getAdditionalCell();
            Integer $rowStartIndex = this.getRowStartIndex();
            result = result * 59 + ($rowStartIndex == null ? 43 : ((Object)$rowStartIndex).hashCode());
            HSSFSheet $sheet = this.getSheet();
            result = result * 59 + ($sheet == null ? 43 : $sheet.hashCode());
            HSSFRow $hssfRow = this.getHssfRow();
            result = result * 59 + ($hssfRow == null ? 43 : $hssfRow.hashCode());
            Object $fieldVal = this.getFieldVal();
            result = result * 59 + ($fieldVal == null ? 43 : $fieldVal.hashCode());
            EasyExcel $easyExcel = this.getEasyExcel();
            result = result * 59 + ($easyExcel == null ? 43 : $easyExcel.hashCode());
            return result;
        }

        public String toString() {
            return "ComplexExcelExportService.CreateCell(sheet=" + this.getSheet() + ", hssfRow=" + this.getHssfRow() + ", rowStartIndex=" + this.getRowStartIndex() + ", cellStartIndex=" + this.getCellStartIndex() + ", additionalCell=" + this.getAdditionalCell() + ", fieldVal=" + this.getFieldVal() + ", easyExcel=" + this.getEasyExcel() + ")";
        }

        public CreateCell(HSSFSheet sheet, HSSFRow hssfRow, Integer rowStartIndex, int cellStartIndex, int additionalCell, Object fieldVal, EasyExcel easyExcel) {
            this.sheet = sheet;
            this.hssfRow = hssfRow;
            this.rowStartIndex = rowStartIndex;
            this.cellStartIndex = cellStartIndex;
            this.additionalCell = additionalCell;
            this.fieldVal = fieldVal;
            this.easyExcel = easyExcel;
        }

        public CreateCell() {
        }
    }
}

