/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.service;

import com.wu.framework.easy.excel.service.ComplexExcelExportService;
import com.wu.framework.easy.excel.service.NormalExcelExportService;
import com.wu.framework.easy.excel.stereotype.EasyExcel;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;

public interface ExcelExcelService {
    public static final int TITLE_COLUMN = 0;

    public static byte[] exportExcel(EasyExcel easyExcel, Collection collection) {
        if (easyExcel.isComplicated()) {
            return ComplexExcelExportService.exportExcel(easyExcel, collection);
        }
        return NormalExcelExportService.exportExcel(easyExcel, collection);
    }

    public static List<List> splitList(List list, int len) {
        if (list == null || list.isEmpty() || len < 1) {
            return Collections.emptyList();
        }
        ArrayList<List> result = new ArrayList<List>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List subList = list.subList(i * len, Math.min((i + 1) * len, size));
            result.add(subList);
        }
        return result;
    }

    public static void setRowColumnContent(HSSFCell hssfCell, Object value) {
        Class<Object> valueClass = value.getClass();
        if (valueClass.isAssignableFrom(String.class)) {
            hssfCell.setCellValue(String.valueOf(value));
        } else if (valueClass.isAssignableFrom(Double.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue(((Double)value).doubleValue());
        } else if (valueClass.isAssignableFrom(Integer.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Integer)value).intValue());
        } else if (valueClass.isAssignableFrom(Long.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Long)value).longValue());
        } else if (valueClass.isAssignableFrom(Float.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Float)value).floatValue());
        } else if (valueClass.isAssignableFrom(Date.class)) {
            hssfCell.setCellType(CellType.STRING);
            hssfCell.setCellValue((Date)value);
        } else if (valueClass.isAssignableFrom(Calendar.class)) {
            hssfCell.setCellValue((Calendar)value);
        } else if (valueClass.isAssignableFrom(Boolean.class)) {
            hssfCell.setCellType(CellType.BOOLEAN);
            hssfCell.setCellValue(((Boolean)value).booleanValue());
        } else if (valueClass.isAssignableFrom(HSSFRichTextString.class)) {
            hssfCell.setCellValue((RichTextString)((HSSFRichTextString)value));
        } else {
            hssfCell.setCellValue(String.valueOf(value));
        }
    }
}

