/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.service;

import com.wu.framework.easy.excel.service.ExcelExcelService;
import com.wu.framework.easy.excel.service.style.Style;
import com.wu.framework.easy.excel.service.style.StyleParam;
import com.wu.framework.easy.excel.stereotype.EasyExcel;
import com.wu.framework.easy.excel.stereotype.EasyExcelFiled;
import com.wu.framework.easy.excel.util.ISheetShowContextMethod;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

public class NormalExcelExportService
implements ExcelExcelService {
    public static byte[] exportExcel(final EasyExcel easyExcel, Collection collection) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        HSSFWorkbook workbook = new HSSFWorkbook();
        if (easyExcel.multipleSheet()) {
            List<List> splitList = ExcelExcelService.splitList(new ArrayList(collection), easyExcel.limit());
            ISheetShowContextMethod iSheetShowContextMethod = easyExcel.sheetShowContext().getISheetShowContextMethod().newInstance();
            final List<String> sheetContextList = iSheetShowContextMethod.sheetContext(collection.size(), easyExcel.limit());
            for (int i = 0; i < splitList.size(); ++i) {
                final int finalI = i;
                EasyExcel tempEasyExcel = new EasyExcel(){

                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return easyExcel.annotationType();
                    }

                    @Override
                    public String fileName() {
                        return easyExcel.fileName();
                    }

                    @Override
                    public String sheetName() {
                        return (String)sheetContextList.get(finalI);
                    }

                    @Override
                    public String suffix() {
                        return easyExcel.suffix();
                    }

                    @Override
                    public boolean isComplicated() {
                        return easyExcel.isComplicated();
                    }

                    @Override
                    public boolean useAnnotation() {
                        return easyExcel.useAnnotation();
                    }

                    @Override
                    public Class<? extends Annotation> fieldColumnAnnotation() {
                        return easyExcel.fieldColumnAnnotation();
                    }

                    @Override
                    public String fieldColumnAnnotationAttribute() {
                        return easyExcel.fieldColumnAnnotationAttribute();
                    }

                    @Override
                    public boolean multipleSheet() {
                        return easyExcel.multipleSheet();
                    }

                    @Override
                    public int limit() {
                        return easyExcel.limit();
                    }

                    @Override
                    public EasyExcel.SheetShowContext sheetShowContext() {
                        return easyExcel.sheetShowContext();
                    }

                    @Override
                    public Class<? extends Style> style() {
                        return easyExcel.style();
                    }

                    @Override
                    public boolean titleFixedHead() {
                        return easyExcel.titleFixedHead();
                    }
                };
                NormalExcelExportService.normalSingleSheet(workbook, tempEasyExcel, splitList.get(i));
            }
        } else {
            NormalExcelExportService.normalSingleSheet(workbook, easyExcel, collection);
        }
        workbook.write((OutputStream)out);
        return out.toByteArray();
    }

    public static void normalSingleSheet(HSSFWorkbook workbook, EasyExcel easyExcel, Collection collection) {
        try {
            Iterator iterator = collection.iterator();
            if (!iterator.hasNext()) {
                throw new Exception("\u6570\u636e\u9519\u8bef");
            }
            Object ts = iterator.next();
            HSSFSheet sheet = workbook.createSheet(easyExcel.sheetName());
            sheet.setDefaultColumnWidth(20);
            HSSFCellStyle style = workbook.createCellStyle();
            List fieldList = easyExcel.useAnnotation() ? Arrays.stream(ts.getClass().getDeclaredFields()).filter(field -> null != field.getAnnotation(easyExcel.fieldColumnAnnotation())).peek(field -> field.setAccessible(true)).collect(Collectors.toList()) : Arrays.stream(ts.getClass().getDeclaredFields()).peek(field -> field.setAccessible(true)).collect(Collectors.toList());
            iterator = collection.iterator();
            Object next = iterator.next();
            Class<?> dataEntityType = next.getClass();
            HSSFRow row = sheet.createRow(0);
            if (Map.class.isAssignableFrom(dataEntityType)) {
                Set keySet = ((Map)next).keySet();
                int i = 0;
                for (String key : keySet) {
                    HSSFCell hssfCell = row.createCell(i);
                    hssfCell.setCellStyle(style);
                    HSSFRichTextString text = new HSSFRichTextString(key);
                    ExcelExcelService.setRowColumnContent(hssfCell, text);
                    ++i;
                }
            } else {
                if (easyExcel.titleFixedHead()) {
                    sheet.createFreezePane(fieldList.size(), 1);
                }
                for (int i = 0; i < fieldList.size(); ++i) {
                    String headerName;
                    HSSFCell hssfCell = row.createCell(i);
                    hssfCell.setCellStyle(style);
                    Field field2 = (Field)fieldList.get(i);
                    if (easyExcel.useAnnotation()) {
                        Object[] dropdownOptions;
                        Annotation filedAnnotation = field2.getAnnotation(easyExcel.fieldColumnAnnotation());
                        if (null == filedAnnotation) {
                            return;
                        }
                        Class<? extends Style> styleClass = easyExcel.style();
                        Style newInstance = styleClass.newInstance();
                        HSSFCellStyle tempStyle = newInstance.titleStyle(new StyleParam(workbook, sheet, filedAnnotation, i));
                        hssfCell.setCellStyle(tempStyle);
                        Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)filedAnnotation);
                        headerName = String.valueOf(annotationAttributes.getOrDefault(easyExcel.fieldColumnAnnotationAttribute(), field2.getName()));
                        EasyExcelFiled easyExcelFiled = (EasyExcelFiled)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field2, EasyExcelFiled.class);
                        if (!ObjectUtils.isEmpty((Object)easyExcelFiled) && !ObjectUtils.isEmpty((Object[])(dropdownOptions = easyExcelFiled.dropdownOptions()))) {
                            DataValidationHelper helper = sheet.getDataValidationHelper();
                            CellRangeAddressList addressList = new CellRangeAddressList(1, 9999, i, i);
                            DataValidationConstraint constraint = helper.createExplicitListConstraint((String[])dropdownOptions);
                            DataValidation dataValidation = helper.createValidation(constraint, addressList);
                            if (dataValidation instanceof XSSFDataValidation) {
                                dataValidation.setSuppressDropDownArrow(true);
                                dataValidation.setShowErrorBox(true);
                            } else {
                                dataValidation.setSuppressDropDownArrow(false);
                            }
                            sheet.addValidationData(dataValidation);
                        }
                    } else {
                        headerName = field2.getName();
                    }
                    HSSFRichTextString text = new HSSFRichTextString(headerName);
                    ExcelExcelService.setRowColumnContent(hssfCell, text);
                }
            }
            int index = 0;
            iterator = collection.iterator();
            LinkedList<HSSFCellStyle> columnStyleList = new LinkedList<HSSFCellStyle>();
            while (iterator.hasNext()) {
                row = sheet.createRow(++index);
                Object t = iterator.next();
                if (t instanceof Map) {
                    Collection values = ((Map)t).values();
                    Iterator mapIterator = values.iterator();
                    int k = 0;
                    while (mapIterator.hasNext()) {
                        HSSFCell cell = row.createCell(k);
                        cell.setCellValue((String)mapIterator.next());
                        ++k;
                    }
                    continue;
                }
                for (int i = 0; i < fieldList.size(); ++i) {
                    Annotation filedAnnotation;
                    Field field3 = (Field)fieldList.get(i);
                    HSSFCell hssfCell = row.createCell(i);
                    if (easyExcel.useAnnotation() && null != (filedAnnotation = field3.getAnnotation(easyExcel.fieldColumnAnnotation()))) {
                        HSSFCellStyle tempStyle;
                        Class<? extends Style> styleClass = easyExcel.style();
                        Style newInstance = styleClass.newInstance();
                        if (columnStyleList.size() != fieldList.size()) {
                            tempStyle = newInstance.columnStyle(new StyleParam(workbook, sheet, filedAnnotation, i));
                            columnStyleList.add(tempStyle);
                        } else {
                            tempStyle = (HSSFCellStyle)columnStyleList.get(i);
                        }
                        hssfCell.setCellStyle(tempStyle);
                    }
                    ExcelExcelService.setRowColumnContent(hssfCell, field3.get(t));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static byte[] exportExcelMultipleSheet(EasyExcel easyExcel, List<String> titlist, List<List> dataSet) {
        if (titlist.size() == 0 || !dataSet.iterator().hasNext()) {
            throw new RuntimeException("\u4f20\u5165\u7684\u6570\u636e\u4e0d\u5bf9\uff01");
        }
        byte[] bytes = new byte[]{};
        for (int o = 0; o < dataSet.size(); ++o) {
            NormalExcelExportService.exportExcel(easyExcel, dataSet.get(0));
        }
        return bytes;
    }
}

