/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.service.style;

import com.wu.framework.easy.excel.service.style.Style;
import com.wu.framework.easy.excel.service.style.StyleParam;
import com.wu.framework.easy.excel.stereotype.EasyExcelFiled;
import java.lang.annotation.Annotation;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class DefaultStyle
implements Style {
    @Override
    public HSSFCellStyle titleStyle(StyleParam styleParam) {
        Annotation filedAnnotation = styleParam.getFiledAnnotation();
        if (!EasyExcelFiled.class.isAssignableFrom(filedAnnotation.getClass())) {
            return styleParam.getWorkbook().createCellStyle();
        }
        EasyExcelFiled easyExcelFiled = styleParam.getFiledAnnotation(EasyExcelFiled.class);
        HSSFCellStyle style = styleParam.getWorkbook().createCellStyle();
        style.setFillForegroundColor(easyExcelFiled.titleBackgroundColor());
        style.setFillPattern(easyExcelFiled.fillPatternType());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = styleParam.getWorkbook().createFont();
        font.setFontName(easyExcelFiled.titleFontName());
        font.setColor(easyExcelFiled.titleFontColor());
        font.setFontHeightInPoints(easyExcelFiled.titleFontSize());
        style.setFont(font);
        styleParam.getHssfSheet().setColumnWidth(styleParam.getColumnIndex().intValue(), easyExcelFiled.width() * 255);
        style.setWrapText(easyExcelFiled.wrapText());
        return style;
    }

    @Override
    public HSSFCellStyle columnStyle(StyleParam styleParam) {
        Annotation filedAnnotation = styleParam.getFiledAnnotation();
        if (!EasyExcelFiled.class.isAssignableFrom(filedAnnotation.getClass())) {
            return styleParam.getWorkbook().createCellStyle();
        }
        EasyExcelFiled easyExcelFiled = styleParam.getFiledAnnotation(EasyExcelFiled.class);
        HSSFCellStyle style = styleParam.getWorkbook().createCellStyle();
        style.setFillBackgroundColor(easyExcelFiled.columnBackgroundColor());
        style.setBorderBottom(BorderStyle.THIN);
        style.setBorderLeft(BorderStyle.THIN);
        style.setBorderTop(BorderStyle.THIN);
        style.setBorderRight(BorderStyle.THIN);
        style.setAlignment(HorizontalAlignment.CENTER);
        HSSFFont font = styleParam.getWorkbook().createFont();
        font.setFontName(easyExcelFiled.columnFontName());
        font.setFontHeightInPoints(easyExcelFiled.columnFontSize());
        font.setColor(easyExcelFiled.columnFontColor());
        style.setFont(font);
        style.setFont(font);
        styleParam.getHssfSheet().setColumnWidth(styleParam.getColumnIndex().intValue(), easyExcelFiled.width() * 255);
        style.setWrapText(easyExcelFiled.wrapText());
        return style;
    }
}

