/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.util;

import com.wu.framework.easy.excel.stereotype.EasyExcelFiled;
import com.wu.framework.inner.layer.util.BeanTypeTransformUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.poi.ss.format.CellFormat;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.util.LocaleUtil;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.web.multipart.MultipartFile;

public class FastExcelImp {
    public static <T> List<T> parseExcel(String path, Class<T> clazz) {
        File file = new File(path);
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FastExcelImp.parseExcel(workbook, clazz);
    }

    public static <T> List<T> parseExcel(MultipartFile file, Class<T> clazz) {
        InputStream is = null;
        try {
            is = file.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FastExcelImp.parseExcel(is, clazz);
    }

    public static <T> List<T> parseExcel(InputStream is, Class<T> clazz) {
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)is);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return FastExcelImp.parseExcel(workbook, clazz);
    }

    public static <T> List<T> parseExcel(Workbook workbook, Class<T> clazz) {
        Sheet sheet = workbook.getSheetAt(0);
        ArrayList rst = new ArrayList();
        if (sheet == null) {
            return rst;
        }
        int firstRowNum = sheet.getFirstRowNum();
        Row row = sheet.getRow(firstRowNum);
        short lastCellNum = row.getLastCellNum();
        Map<String, Integer> cellNames = FastExcelImp.getCellMapping(row, lastCellNum);
        Map<String, Field> fieldMap = FastExcelImp.getFieldMapping(clazz);
        int lastRowNum = sheet.getLastRowNum();
        Set<String> keys = cellNames.keySet();
        try {
            CellFormat cellFormat = CellFormat.getInstance((Locale)LocaleUtil.getUserLocale(), (String)"General");
            for (int rowIndex = ++firstRowNum; rowIndex <= lastRowNum; ++rowIndex) {
                Row r = sheet.getRow(rowIndex);
                if (Map.class.isAssignableFrom(clazz)) {
                    Map map = (Map)clazz.newInstance();
                    cellNames.entrySet().stream().forEach(stringIntegerEntry -> {
                        Cell cell = r.getCell(((Integer)stringIntegerEntry.getValue()).intValue());
                        String v = "";
                        if (cell != null) {
                            v = cellFormat.apply((Cell)cell).text;
                        }
                        map.put(stringIntegerEntry.getKey(), v);
                    });
                    rst.add(map);
                    continue;
                }
                T inst = clazz.newInstance();
                for (String key : keys) {
                    Integer col;
                    Cell cel;
                    Field field = fieldMap.get(key);
                    if (field == null || (cel = r.getCell((col = cellNames.get(key)).intValue())) == null) continue;
                    field.setAccessible(true);
                    String text = cellFormat.apply((Cell)cel).text;
                    Object transform = BeanTypeTransformUtil.transform((String)text, field.getType());
                    field.set(inst, transform);
                }
                rst.add(inst);
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
        }
        return rst;
    }

    private static Map<String, Integer> getCellMapping(Row row, short lastCellNum) {
        HashMap<String, Integer> cellNames = new HashMap<String, Integer>();
        for (int col = 0; col < lastCellNum; ++col) {
            Cell cell = row.getCell(col);
            String val = cell.getStringCellValue();
            cellNames.put(val, col);
        }
        return cellNames;
    }

    private static <T> Map<String, Field> getFieldMapping(Class<T> clazz, Class annotationClass, String annotationProfile) {
        HashMap<String, Field> annotations = new HashMap<String, Field>();
        Field[] fields = clazz.getDeclaredFields();
        if (fields == null || fields.length < 1) {
            return annotations;
        }
        for (Field field : fields) {
            Object annotation = field.getAnnotation(annotationClass);
            if (annotation == null) {
                annotations.put(field.getName(), field);
                continue;
            }
            Map annotationAttributes = AnnotationUtils.getAnnotationAttributes(annotation);
            annotations.put(annotationAttributes.getOrDefault(annotationProfile, "").toString(), field);
        }
        return annotations;
    }

    private static <T> Map<String, Field> getFieldMapping(Class<T> clazz) {
        return FastExcelImp.getFieldMapping(clazz, EasyExcelFiled.class, "name");
    }
}

