/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.adapter;

import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.processor.EasyExcelProcessor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class ExcelExcelServiceAdapter {
    private final List<EasyExcelProcessor> easyExcelProcessors;

    public ExcelExcelServiceAdapter(List<EasyExcelProcessor> easyExcelProcessors) {
        this.easyExcelProcessors = easyExcelProcessors;
    }

    public byte[] exportExcel(Object excelBean, EasyExcelPoint easyExcelPoint) {
        List easyExcelProcessorList = this.easyExcelProcessors.stream().sorted(Comparator.comparing(EasyExcelProcessor::order).reversed()).collect(Collectors.toList());
        for (EasyExcelProcessor easyExcelProcessor : easyExcelProcessorList) {
            if (!easyExcelProcessor.support(excelBean)) continue;
            return easyExcelProcessor.exportExcel(excelBean, easyExcelPoint);
        }
        throw new RuntimeException("\u65e0\u6cd5\u5bfc\u51faExcel");
    }

    public void exportExcel(Object excelBean, EasyExcelPoint easyExcelPoint, FileOutputStream fileOutputStream) throws IOException {
        List<EasyExcelProcessor> easyExcelProcessorList = this.easyExcelProcessors.stream().sorted(Comparator.comparing(EasyExcelProcessor::order).reversed()).toList();
        for (EasyExcelProcessor easyExcelProcessor : easyExcelProcessorList) {
            if (!easyExcelProcessor.support(excelBean)) continue;
            easyExcelProcessor.exportExcel(excelBean, easyExcelPoint, fileOutputStream);
            return;
        }
        throw new RuntimeException("\u65e0\u6cd5\u5bfc\u51faExcel");
    }

    public <T> List<T> importExcel(Object excel) {
        List<EasyExcelProcessor> easyExcelProcessorList = this.easyExcelProcessors.stream().sorted(Comparator.comparing(EasyExcelProcessor::order).reversed()).toList();
        for (EasyExcelProcessor easyExcelProcessor : easyExcelProcessorList) {
            if (!easyExcelProcessor.support(excel)) continue;
            return easyExcelProcessor.importExcel(excel);
        }
        throw new RuntimeException("\u65e0\u6cd5\u5bfc\u5165Excel");
    }
}

