/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.processor;

import com.wu.framework.easy.excel.CellCoordinate;
import com.wu.framework.easy.excel.endpoint.EasyExcelFiledPoint;
import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.processor.EasyExcelProcessor;
import com.wu.framework.easy.excel.util.ISheetShowContextMethod;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Date;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.util.ObjectUtils;

public abstract class AbstractEasyExcelProcessor
implements EasyExcelProcessor {
    int TITLE_COLUMN = 0;

    static List<List> splitList(List list, int len) {
        if (list == null || list.isEmpty() || len < 1) {
            return Collections.emptyList();
        }
        ArrayList<List> result = new ArrayList<List>();
        int size = list.size();
        int count = (size + len - 1) / len;
        for (int i = 0; i < count; ++i) {
            List subList = list.subList(i * len, Math.min((i + 1) * len, size));
            result.add(subList);
        }
        return result;
    }

    static void setRowColumnContent(Cell hssfCell, Object value) {
        if (null == value) {
            return;
        }
        Class<Object> valueClass = value.getClass();
        if (valueClass.isAssignableFrom(String.class)) {
            hssfCell.setCellValue(String.valueOf(value));
        } else if (valueClass.isAssignableFrom(Double.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue(((Double)value).doubleValue());
        } else if (valueClass.isAssignableFrom(Integer.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Integer)value).intValue());
        } else if (valueClass.isAssignableFrom(Long.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Long)value).longValue());
        } else if (valueClass.isAssignableFrom(Float.class)) {
            hssfCell.setCellType(CellType.NUMERIC);
            hssfCell.setCellValue((double)((Float)value).floatValue());
        } else if (valueClass.isAssignableFrom(java.util.Date.class)) {
            hssfCell.setCellType(CellType.STRING);
            hssfCell.setCellValue((java.util.Date)value);
        } else if (valueClass.isAssignableFrom(Calendar.class)) {
            hssfCell.setCellValue((Calendar)value);
        } else if (valueClass.isAssignableFrom(Boolean.class)) {
            hssfCell.setCellType(CellType.BOOLEAN);
            hssfCell.setCellValue(((Boolean)value).booleanValue());
        } else if (valueClass.isAssignableFrom(RichTextString.class)) {
            hssfCell.setCellValue((RichTextString)value);
        } else {
            hssfCell.setCellValue(String.valueOf(value));
        }
    }

    public static boolean isWrapClass(Class<?> clazz) {
        try {
            if (String.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (byte[].class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Byte.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (Long.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Long.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (Integer.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Integer.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (Short.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (Float.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Float.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Boolean.TYPE.isAssignableFrom(clazz)) {
                return true;
            }
            if (LocalDateTime.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (LocalDate.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return true;
            }
            if (Date.class.isAssignableFrom(clazz)) {
                return true;
            }
            return ((Class)clazz.getField("TYPE").get(null)).isPrimitive();
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public byte[] exportExcel(Object excelBean, EasyExcelPoint easyExcelPoint) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Workbook workbook = this.createWorkbook(excelBean, easyExcelPoint);
        try {
            workbook.write((OutputStream)out);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return out.toByteArray();
    }

    public Workbook createWorkbook(Object excelBean, EasyExcelPoint easyExcelPoint) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        List<Object> excelBeanList = excelBean instanceof Collection ? Arrays.asList(((Collection)excelBean).toArray()) : Arrays.asList(excelBean);
        try {
            if (easyExcelPoint.isMultipleSheet()) {
                List<List> splitList = AbstractEasyExcelProcessor.splitList(excelBeanList, easyExcelPoint.getLimit());
                ISheetShowContextMethod iSheetShowContextMethod = easyExcelPoint.getSheetShowContext().getISheetShowContextMethod().newInstance();
                List<String> sheetContextList = iSheetShowContextMethod.sheetContext(excelBeanList.size(), easyExcelPoint.getLimit());
                for (int i = 0; i < splitList.size(); ++i) {
                    easyExcelPoint.setSheetName(sheetContextList.get(i));
                    this.processorSheet((Workbook)workbook, i, easyExcelPoint, splitList.get(i));
                }
            } else {
                this.processorSheet((Workbook)workbook, 0, easyExcelPoint, excelBeanList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return workbook;
    }

    @Override
    public void exportExcel(Object excelBean, EasyExcelPoint easyExcelPoint, FileOutputStream fileOutputStream) throws IOException {
        Workbook workbook = this.createWorkbook(excelBean, easyExcelPoint);
        workbook.write((OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public void processorSheet(Workbook workbook, int sheetIndex, EasyExcelPoint easyExcel, List sheetList) {
        try {
            Iterator iterator = sheetList.iterator();
            if (!iterator.hasNext()) {
                throw new Exception("\u6570\u636e\u9519\u8bef");
            }
            Object ts = iterator.next();
            if (Collection.class.isAssignableFrom(ts.getClass())) {
                for (int i = 0; i < sheetList.size(); ++i) {
                    easyExcel.setSheetName(easyExcel.getSheetName() + "-1");
                    this.processorSheet(workbook, sheetIndex + i, easyExcel, (List)sheetList.get(i));
                }
                return;
            }
            this.processorSingleSheet(workbook, sheetIndex, easyExcel, sheetList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public abstract void padMapRowData(Sheet var1, EasyExcelPoint var2, List<Map<?, ?>> var3, int var4, int var5);

    public void processorSingleSheet(Workbook workbook, int sheetIndex, EasyExcelPoint easyExcel, List<?> beanList) {
        try {
            Sheet singleSheet = this.createSingleSheet(workbook, easyExcel, beanList);
            if (beanList.stream().findFirst().isEmpty()) {
                throw new RuntimeException("\u6570\u636e\u6709\u8bef");
            }
            Object firstBean = beanList.stream().findFirst().get();
            Class<?> firstBeanClass = firstBean.getClass();
            if (AbstractEasyExcelProcessor.isWrapClass(firstBeanClass)) {
                return;
            }
            if (Map.class.isAssignableFrom(firstBeanClass)) {
                easyExcel.setExportTypeEnum(EasyExcelPoint.ExportTypeEnum.MAP);
                List<EasyExcelFiledPoint> easyExcelFiledPointList = this.createRowTitle(workbook, singleSheet, easyExcel, beanList, 0);
                easyExcel.setExcelFiledPointList(easyExcelFiledPointList);
                this.padMapRowData(singleSheet, easyExcel, beanList, 1, 0);
            } else {
                easyExcel.setExportTypeEnum(EasyExcelPoint.ExportTypeEnum.JAVA_BEAN);
                List<EasyExcelFiledPoint> easyExcelFiledPointList = this.createRowTitle(workbook, singleSheet, easyExcel, beanList, 0);
                easyExcel.setExcelFiledPointList(easyExcelFiledPointList);
                this.padRowData(singleSheet, easyExcel, beanList, 1, 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Sheet createSingleSheet(Workbook workbook, EasyExcelPoint easyExcel, List beanList) throws InstantiationException, IllegalAccessException {
        Sheet sheet = workbook.createSheet(easyExcel.getSheetName());
        sheet.setDefaultColumnWidth(20);
        return sheet;
    }

    public abstract List<EasyExcelFiledPoint> createRowTitle(Workbook var1, Sheet var2, EasyExcelPoint var3, List<?> var4, int var5) throws InstantiationException, IllegalAccessException;

    public abstract void padRowData(Sheet var1, EasyExcelPoint var2, List var3, int var4, int var5);

    @Override
    public int order() {
        return 0;
    }

    public Integer getLastColumnIndex(List<EasyExcelFiledPoint> easyExcelFiledPoints, Integer defaultLastColumnIndex) {
        if (easyExcelFiledPoints.isEmpty()) {
            return defaultLastColumnIndex;
        }
        EasyExcelFiledPoint easyExcelFiledPoint = easyExcelFiledPoints.stream().max(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
        if (ObjectUtils.isEmpty(easyExcelFiledPoint.getExcelBeanFiledPointList())) {
            return easyExcelFiledPoint.getCurrentColumnIndex();
        }
        return this.getLastColumnIndex(easyExcelFiledPoint.getExcelBeanFiledPointList(), defaultLastColumnIndex);
    }

    public void mergeColumn(CellCoordinate cellCoordinate, Sheet hssfSheet, int mergeColumnLength) {
        int endColumnIndex;
        int startRowIndex = cellCoordinate.getStartRowIndex();
        int endRowIndex = cellCoordinate.getEndRowIndex();
        int startColumnIndex = cellCoordinate.getStartColumnIndex();
        if (startColumnIndex > (endColumnIndex = cellCoordinate.getEndColumnIndex()) || startRowIndex > endRowIndex) {
            return;
        }
        if (startRowIndex == endRowIndex) {
            return;
        }
        CellRangeAddress region = new CellRangeAddress(startRowIndex, endRowIndex, endColumnIndex - (mergeColumnLength - 1), endColumnIndex);
        hssfSheet.addMergedRegionUnsafe(region);
        cellCoordinate.setEndColumnIndex(endColumnIndex - mergeColumnLength);
        this.mergeColumn(cellCoordinate, hssfSheet, mergeColumnLength);
    }
}

