/*
 * Decompiled with CFR 0.152.
 */
package com.wu.framework.easy.excel.processor;

import com.wu.framework.easy.excel.CellCoordinate;
import com.wu.framework.easy.excel.endpoint.EasyExcelFiledPoint;
import com.wu.framework.easy.excel.endpoint.EasyExcelPoint;
import com.wu.framework.easy.excel.endpoint.convert.EasyExcelFiledPointConvert;
import com.wu.framework.easy.excel.processor.AbstractEasyExcelProcessor;
import com.wu.framework.easy.excel.processor.EasyExcelProcessor;
import com.wu.framework.easy.excel.service.style.DefaultStyleParam;
import com.wu.framework.easy.excel.service.style.Style;
import com.wu.framework.easy.excel.stereotype.EasyExcelFiled;
import com.wu.framework.easy.excel.toolkit.DynamicEasyExcelContextHolder;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractNormalBeanEasyExcelProcessor
extends AbstractEasyExcelProcessor
implements EasyExcelProcessor {
    private static EasyExcelFiledPointConvert easyExcelFiledPointConvert = new EasyExcelFiledPointConvert();
    private Logger log = LoggerFactory.getLogger(AbstractNormalBeanEasyExcelProcessor.class);

    @Override
    public boolean support(Object excelBean) {
        return excelBean != null;
    }

    @Override
    public <T> List<T> importExcel(Object excel) {
        return null;
    }

    @Override
    public int order() {
        return -1;
    }

    public List<EasyExcelFiledPoint> handlerMapRowTitle(Workbook workbook, Sheet sheet, EasyExcelPoint easyExcelPoint, List<?> beanList, int startColumnIndex) {
        int easyExcelFiledPointStartColumnIndex = startColumnIndex;
        List<?> mapList = beanList;
        ArrayList<EasyExcelFiledPoint> excelFiledPointList = new ArrayList<EasyExcelFiledPoint>();
        Map<String, Object> mergedMap = mapList.stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, entry -> Optional.ofNullable(entry.getValue()).orElse(""), (A, B) -> {
            if (!ObjectUtils.isEmpty((Object)A)) {
                return A;
            }
            return B;
        }));
        for (Map.Entry<String, Object> stringObjectEntry : mergedMap.entrySet()) {
            String key = stringObjectEntry.getKey();
            Object o = stringObjectEntry.getValue();
            EasyExcelFiledPoint easyExcelFiledPoint = new EasyExcelFiledPoint();
            easyExcelFiledPoint.setFieldName(key);
            easyExcelFiledPoint.setName(key);
            if (!ObjectUtils.isEmpty((Object)o)) {
                if (AbstractNormalBeanEasyExcelProcessor.isWrapClass(o.getClass())) {
                    easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                    ++easyExcelFiledPointStartColumnIndex;
                } else if (Collection.class.isAssignableFrom(o.getClass())) {
                    if (AbstractNormalBeanEasyExcelProcessor.isWrapClass(((List)o).get(0).getClass())) {
                        easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                        easyExcelFiledPoints = new ArrayList<EasyExcelFiledPoint>();
                        EasyExcelFiledPoint normal = new EasyExcelFiledPoint();
                        normal.setName(key);
                        normal.setFieldName(key);
                        normal.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                        easyExcelFiledPoints.add(normal);
                        easyExcelFiledPoint.setExcelBeanFiledPointList(easyExcelFiledPoints);
                        easyExcelFiledPoint.setCollectionFiled(true);
                        ++easyExcelFiledPointStartColumnIndex;
                    } else {
                        easyExcelFiledPoints = this.handlerMapRowTitle(workbook, sheet, easyExcelPoint, (List)o, startColumnIndex);
                        easyExcelFiledPoint.setCollectionFiled(true);
                        easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                        lastColumnIndex = this.getLastColumnIndex(easyExcelFiledPoints, easyExcelFiledPointStartColumnIndex);
                        easyExcelFiledPointStartColumnIndex = lastColumnIndex + 1;
                        easyExcelFiledPoint.setExcelBeanFiledPointList(easyExcelFiledPoints);
                    }
                } else if (Map.class.isAssignableFrom(o.getClass())) {
                    easyExcelFiledPoints = this.handlerMapRowTitle(workbook, sheet, easyExcelPoint, List.of(o), startColumnIndex);
                    easyExcelFiledPoint.setBeanFiled(true);
                    easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                    lastColumnIndex = this.getLastColumnIndex(easyExcelFiledPoints, easyExcelFiledPointStartColumnIndex);
                    easyExcelFiledPointStartColumnIndex = lastColumnIndex + 1;
                    easyExcelFiledPoint.setExcelBeanFiledPointList(easyExcelFiledPoints);
                }
            } else {
                easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                ++easyExcelFiledPointStartColumnIndex;
            }
            excelFiledPointList.add(easyExcelFiledPoint);
        }
        return excelFiledPointList;
    }

    public List<EasyExcelFiledPoint> handlerBeanRowTitle(Workbook workbook, Sheet sheet, EasyExcelPoint easyExcelPoint, Class<?> firstBeanClass, int startColumnIndex) {
        List excelFiledPointList;
        int easyExcelFiledPointStartColumnIndex = startColumnIndex;
        if (easyExcelPoint.isUseAnnotation()) {
            this.log.debug("use annotation export excel");
            excelFiledPointList = Arrays.stream(firstBeanClass.getDeclaredFields()).filter(field -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)field, easyExcelPoint.getFieldColumnAnnotation())).peek(field -> field.setAccessible(true)).map(field -> {
                EasyExcelFiled easyExcelFiled = (EasyExcelFiled)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)field, EasyExcelFiled.class);
                EasyExcelFiledPoint converter = new EasyExcelFiledPoint();
                if (easyExcelFiled != null) {
                    converter = easyExcelFiledPointConvert.converter(easyExcelFiled);
                } else {
                    Annotation filedAnnotation = field.getAnnotation(easyExcelPoint.getFieldColumnAnnotation());
                    Map annotationAttributes = AnnotationUtils.getAnnotationAttributes((Annotation)filedAnnotation);
                    String columnTitleName = String.valueOf(annotationAttributes.getOrDefault(easyExcelPoint.getFieldColumnAnnotationAttribute(), field.getName()));
                    converter.setName(columnTitleName);
                }
                converter.setField((Field)field);
                converter.setFieldName(field.getName());
                converter.setEasyExcelFiled(easyExcelFiled);
                return converter;
            }).sorted(Comparator.comparing(EasyExcelFiledPoint::getSerialNumber).reversed()).collect(Collectors.toList());
        } else {
            excelFiledPointList = Arrays.stream(firstBeanClass.getDeclaredFields()).peek(field -> field.setAccessible(true)).map(field -> {
                EasyExcelFiledPoint easyExcelFiledPoint = new EasyExcelFiledPoint();
                easyExcelFiledPoint.setField((Field)field);
                easyExcelFiledPoint.setFieldName(field.getName());
                easyExcelFiledPoint.setName(field.getName());
                return easyExcelFiledPoint;
            }).collect(Collectors.toList());
        }
        List<EasyExcelFiledPoint> easyExcelFiledPointList = excelFiledPointList.stream().sorted(Comparator.comparing(EasyExcelFiledPoint::getSerialNumber)).collect(Collectors.toList());
        for (EasyExcelFiledPoint easyExcelFiledPoint : easyExcelFiledPointList) {
            Style newInstance;
            Field field2 = easyExcelFiledPoint.getField();
            Class<?> fieldType = field2.getType();
            if (!AbstractNormalBeanEasyExcelProcessor.isWrapClass(fieldType)) {
                if (Collection.class.isAssignableFrom(fieldType)) {
                    ParameterizedType type = (ParameterizedType)field2.getGenericType();
                    List<EasyExcelFiledPoint> easyExcelFiledPoints = this.handlerBeanRowTitle(workbook, sheet, easyExcelPoint, (Class)type.getActualTypeArguments()[0], easyExcelFiledPointStartColumnIndex);
                    easyExcelFiledPoint.setExcelBeanFiledPointList(easyExcelFiledPoints);
                    easyExcelFiledPoint.setCollectionFiled(true);
                    easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                    Integer lastColumnIndex = this.getLastColumnIndex(easyExcelFiledPoints, easyExcelFiledPointStartColumnIndex);
                    easyExcelFiledPointStartColumnIndex = lastColumnIndex + 1;
                } else {
                    List<EasyExcelFiledPoint> easyExcelFiledPoints = this.handlerBeanRowTitle(workbook, sheet, easyExcelPoint, fieldType, easyExcelFiledPointStartColumnIndex);
                    easyExcelFiledPoint.setExcelBeanFiledPointList(easyExcelFiledPoints);
                    easyExcelFiledPoint.setBeanFiled(true);
                    easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                    Integer lastColumnIndex = this.getLastColumnIndex(easyExcelFiledPoints, easyExcelFiledPointStartColumnIndex);
                    easyExcelFiledPointStartColumnIndex = lastColumnIndex + 1;
                }
            } else {
                easyExcelFiledPoint.setCurrentColumnIndex(easyExcelFiledPointStartColumnIndex);
                ++easyExcelFiledPointStartColumnIndex;
            }
            Class<? extends Style> styleClass = easyExcelPoint.getStyle();
            try {
                newInstance = styleClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            CellStyle tempStyle = newInstance.columnStyle(new DefaultStyleParam(workbook, sheet, easyExcelFiledPoint));
            easyExcelFiledPoint.setCellStyle(tempStyle);
        }
        return easyExcelFiledPointList;
    }

    public List<EasyExcelFiledPoint> handlerCreateRowTitle(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<EasyExcelFiledPoint> excelFiledPointList, int columnIndex) throws InstantiationException, IllegalAccessException {
        Row row;
        List<String> peek;
        Workbook workbook = hssfSheet.getWorkbook();
        Sheet sheet = hssfSheet;
        sheet.setDefaultColumnWidth(20);
        CellStyle style = workbook.getCellStyleAt(columnIndex);
        if (style == null) {
            style = workbook.createCellStyle();
        }
        if (!ObjectUtils.isEmpty(peek = DynamicEasyExcelContextHolder.peek())) {
            excelFiledPointList = excelFiledPointList.stream().filter(easyExcelFiledPoint -> !peek.contains(easyExcelFiledPoint.getField().getName())).collect(Collectors.toList());
        }
        if ((row = sheet.getRow(this.TITLE_COLUMN)) == null) {
            row = sheet.createRow(this.TITLE_COLUMN);
        }
        for (EasyExcelFiledPoint easyExcelFiledPoint2 : excelFiledPointList) {
            String headerName;
            Integer currentColumnIndex = easyExcelFiledPoint2.getCurrentColumnIndex();
            if (easyExcelFiledPoint2.isBeanFiled() || easyExcelFiledPoint2.isCollectionFiled()) {
                this.handlerCreateRowTitle(hssfSheet, easyExcelPoint, easyExcelFiledPoint2.getExcelBeanFiledPointList(), 0);
                continue;
            }
            Cell hssfCell = row.getCell(currentColumnIndex.intValue());
            if (null == hssfCell) {
                hssfCell = row.createCell(currentColumnIndex.intValue());
            }
            hssfCell.setCellStyle(style);
            if (easyExcelPoint.isUseAnnotation()) {
                Class<? extends Style> styleClass = easyExcelPoint.getStyle();
                Style newInstance = styleClass.newInstance();
                CellStyle tempStyle = newInstance.titleStyle(new DefaultStyleParam(workbook, sheet, easyExcelFiledPoint2));
                hssfCell.setCellStyle(tempStyle);
                headerName = easyExcelFiledPoint2.getName();
                Object[] dropdownOptions = easyExcelFiledPoint2.getDropdownOptions();
                if (!ObjectUtils.isEmpty((Object[])dropdownOptions)) {
                    DataValidationHelper helper = sheet.getDataValidationHelper();
                    CellRangeAddressList addressList = new CellRangeAddressList(1, 9999, currentColumnIndex.intValue(), currentColumnIndex + 1);
                    DataValidationConstraint constraint = helper.createExplicitListConstraint((String[])dropdownOptions);
                    DataValidation dataValidation = helper.createValidation(constraint, addressList);
                    if (dataValidation instanceof XSSFDataValidation) {
                        dataValidation.setSuppressDropDownArrow(true);
                        dataValidation.setShowErrorBox(true);
                    } else {
                        dataValidation.setSuppressDropDownArrow(false);
                    }
                    sheet.addValidationData(dataValidation);
                }
            } else {
                headerName = easyExcelFiledPoint2.getName();
            }
            HSSFRichTextString text = new HSSFRichTextString(headerName);
            AbstractNormalBeanEasyExcelProcessor.setRowColumnContent(hssfCell, text);
        }
        return excelFiledPointList;
    }

    @Override
    public List<EasyExcelFiledPoint> createRowTitle(Workbook workbook, Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<?> beanList, int columnIndex) throws InstantiationException, IllegalAccessException {
        List<EasyExcelFiledPoint> excelFiledPointList;
        Sheet sheet = hssfSheet;
        sheet.setDefaultColumnWidth(20);
        if (EasyExcelPoint.ExportTypeEnum.JAVA_BEAN.equals((Object)easyExcelPoint.getExportTypeEnum())) {
            Object firstBean = beanList.stream().filter(Objects::nonNull).findFirst().get();
            Class<?> firstBeanClass = firstBean.getClass();
            excelFiledPointList = this.handlerBeanRowTitle(workbook, sheet, easyExcelPoint, firstBeanClass, 0);
        } else {
            excelFiledPointList = this.handlerMapRowTitle(workbook, sheet, easyExcelPoint, beanList, 0);
        }
        List<EasyExcelFiledPoint> peekOnlyExportField = DynamicEasyExcelContextHolder.peekOnlyExportField();
        if (peekOnlyExportField == null) {
            List<String> peek = DynamicEasyExcelContextHolder.peekIgnoreField();
            if (!ObjectUtils.isEmpty(peek)) {
                excelFiledPointList = excelFiledPointList.stream().filter(easyExcelFiledPoint -> !peek.contains(easyExcelFiledPoint.getFieldName())).collect(Collectors.toList());
            }
        } else {
            excelFiledPointList = peekOnlyExportField;
        }
        if (easyExcelPoint.isTitleFixedHead()) {
            sheet.createFreezePane(excelFiledPointList.size(), this.TITLE_COLUMN + 1);
        }
        this.handlerCreateRowTitle(hssfSheet, easyExcelPoint, excelFiledPointList, columnIndex);
        return excelFiledPointList;
    }

    public CellCoordinate handlerPadOneRowData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<EasyExcelFiledPoint> excelFiledPointList, Object rowData, CellCoordinate cellCoordinate, Boolean isDeepMerge) {
        int lastCellStartRowIndex = cellCoordinate.getStartRowIndex();
        int lastCellEndRowIndex = cellCoordinate.getEndRowIndex();
        int lastCellStartColumnIndex = cellCoordinate.getStartColumnIndex();
        int lastCellEndColumnIndex = cellCoordinate.getEndColumnIndex();
        int startRowIndex = cellCoordinate.getEndRowIndex();
        try {
            LinkedList columnStyleList = new LinkedList();
            Row row = hssfSheet.getRow(startRowIndex);
            if (row == null) {
                row = hssfSheet.createRow(startRowIndex);
            }
            for (EasyExcelFiledPoint easyExcelFiledPoint : excelFiledPointList) {
                Integer currentColumnIndex = easyExcelFiledPoint.getCurrentColumnIndex();
                Field field = easyExcelFiledPoint.getField();
                Object fieldValue = field.get(rowData);
                if (easyExcelFiledPoint.isBeanFiled()) {
                    if (null == fieldValue) {
                        cellCoordinate.setEndColumnIndex(currentColumnIndex + easyExcelFiledPoint.getExcelBeanFiledPointList().size());
                        continue;
                    }
                    cellCoordinate.setEndColumnIndex(currentColumnIndex);
                    cellCoordinate = this.handlerPadOneRowData(hssfSheet, easyExcelPoint, easyExcelFiledPoint.getExcelBeanFiledPointList(), fieldValue, cellCoordinate, isDeepMerge);
                    cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() - 1);
                    continue;
                }
                if (easyExcelFiledPoint.isCollectionFiled()) {
                    List fieldValueList = (List)fieldValue;
                    if (ObjectUtils.isEmpty((Object)fieldValueList)) {
                        cellCoordinate.setEndColumnIndex(cellCoordinate.getEndColumnIndex() + 1);
                        continue;
                    }
                    cellCoordinate.setEndColumnIndex(currentColumnIndex);
                    cellCoordinate.setStartRowIndex(startRowIndex);
                    cellCoordinate = this.handlerPadRowData(hssfSheet, easyExcelPoint, easyExcelFiledPoint.getExcelBeanFiledPointList(), fieldValueList, cellCoordinate, true);
                    cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() - 1);
                    Integer endColumnIndex = currentColumnIndex - 1;
                    CellCoordinate mergeCellCoordinate = new CellCoordinate();
                    mergeCellCoordinate.setStartRowIndex(isDeepMerge != false ? cellCoordinate.getStartRowIndex() : startRowIndex);
                    mergeCellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex());
                    EasyExcelFiledPoint miniColumnEasyExcelFiledPoint = excelFiledPointList.stream().min(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
                    mergeCellCoordinate.setStartColumnIndex(miniColumnEasyExcelFiledPoint.getCurrentColumnIndex());
                    mergeCellCoordinate.setEndColumnIndex(endColumnIndex);
                    this.mergeColumn(mergeCellCoordinate, hssfSheet, 1);
                    continue;
                }
                Cell hssfCell = row.createCell(currentColumnIndex.intValue());
                hssfCell.setCellStyle(easyExcelFiledPoint.getCellStyle());
                AbstractNormalBeanEasyExcelProcessor.setRowColumnContent(hssfCell, fieldValue);
                cellCoordinate.setEndColumnIndex(currentColumnIndex);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (isDeepMerge.booleanValue()) {
            CellCoordinate mergeCellCoordinate = new CellCoordinate();
            mergeCellCoordinate.setStartRowIndex(lastCellStartRowIndex);
            mergeCellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex());
            EasyExcelFiledPoint miniColumnEasyExcelFiledPoint = excelFiledPointList.stream().min(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
            EasyExcelFiledPoint maxColumnEasyExcelFiledPoint = excelFiledPointList.stream().max(Comparator.comparing(EasyExcelFiledPoint::getCurrentColumnIndex)).get();
            mergeCellCoordinate.setStartColumnIndex(miniColumnEasyExcelFiledPoint.getCurrentColumnIndex());
            mergeCellCoordinate.setEndColumnIndex(maxColumnEasyExcelFiledPoint.getCurrentColumnIndex() - 1);
            this.mergeColumn(mergeCellCoordinate, hssfSheet, 1);
        }
        cellCoordinate.setEndRowIndex(cellCoordinate.getEndRowIndex() + 1);
        return cellCoordinate;
    }

    public CellCoordinate handlerPadRowData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List<EasyExcelFiledPoint> excelFiledPointList, List rowData, CellCoordinate cellCoordinate, Boolean isDeepMerge) {
        CellCoordinate startCellCoordinate = cellCoordinate;
        CellCoordinate afterCellCoordinate = cellCoordinate;
        for (Object rowDatum : rowData) {
            cellCoordinate = afterCellCoordinate = this.handlerPadOneRowData(hssfSheet, easyExcelPoint, excelFiledPointList, rowDatum, afterCellCoordinate, isDeepMerge);
        }
        return cellCoordinate;
    }

    @Override
    public void padRowData(Sheet hssfSheet, EasyExcelPoint easyExcelPoint, List rowData, int rowIndex, int columnIndex) {
        List<EasyExcelFiledPoint> excelFiledPointList = easyExcelPoint.getExcelFiledPointList();
        CellCoordinate cellCoordinate = new CellCoordinate();
        cellCoordinate.setStartRowIndex(rowIndex);
        cellCoordinate.setEndRowIndex(rowIndex);
        cellCoordinate.setStartColumnIndex(columnIndex);
        cellCoordinate.setEndColumnIndex(columnIndex);
        this.handlerPadRowData(hssfSheet, easyExcelPoint, excelFiledPointList, rowData, cellCoordinate, false);
    }
}

